% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern-plot.R
\name{degmod}
\alias{degmod}
\alias{patternPlotUI}
\alias{patternPlotServer}
\title{Pattern plot module}
\usage{
patternPlotUI(id, panel, tab)

patternPlotServer(id, obj, coldata, plot_args, config)
}
\arguments{
\item{id}{Module id}

\item{panel}{string, can be 'sidebar' or 'main'}

\item{tab}{string, if 'plot' show plot settings, if 'table' show table settings;
if 'both', show settings for both.}

\item{obj}{reactiveValues object containing carnation object}

\item{coldata}{reactiveValues object containing object metadata}

\item{plot_args}{reactive containing 'gene_scratchpad' (genes selected in scratchpad) &
'upset_data' (list containing data from upset plot module)}

\item{config}{reactive list with config settings}
}
\value{
UI returns tagList with module UI
server invisibly returns NULL (used for side effects)
}
\description{
Module UI & server to generate pattern plots.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
library(shiny)
library(DESeq2)

# Create reactive values to simulate app state
oobj <- make_example_carnation_object()

obj <- reactiveValues(
   dds = oobj$dds,
   rld = oobj$rld,
   res = oobj$res,
   all_dds = oobj$all_dds,
   all_rld = oobj$all_rld,
   dds_mapping = oobj$dds_mapping
)

cdata <- lapply(oobj$rld, function(x) colData(x))

coldata <- reactiveValues( all=cdata, curr=cdata )

plot_args <- reactive({
  list(
    gene_scratchpad=c('gene1', 'gene2'),
    upset_data=list(genes=NULL, labels=NULL)
  )
})

config <- reactiveVal(get_config())

shinyApp(
  ui = fluidPage(
         sidebarPanel(
           patternPlotUI('p', 'sidebar', 'both'),
           conditionalPanel(condition = "input.pattern_mode == 'Plot'",
             patternPlotUI('p', 'sidebar', 'plot')
           ),
           conditionalPanel(condition = "input.pattern_mode == 'Table'",
             patternPlotUI('p', 'sidebar', 'table')
           )
         ),
         mainPanel(
           tabsetPanel(id='pattern_mode',
             tabPanel('Plot',
               patternPlotUI('p', 'plot')
             ), # tabPanel plot

             tabPanel('Cluster membership',
               patternPlotUI('p', 'table')
             ) # tabPanel cluster_membership

           ) # tabsetPanel pattern_mode
         ) # tabPanel pattern_analysis
       ),
  server = function(input, output, session){
             patternPlotServer('deg_plot', obj, coldata,
                               plot_args, config)
           }
)
\dontshow{\}) # examplesIf}
}
