% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access-functions.R
\name{check_user_access}
\alias{check_user_access}
\title{Get data areas a user has access to}
\usage{
check_user_access(al, u, admin = "admin")
}
\arguments{
\item{al}{list with access settings; should have two elements - user_group & data_area}

\item{u}{user name}

\item{admin}{Admin user group}
}
\value{
list of user groups and data areas
}
\description{
This function takes a username and returns a
list with two elements:
}
\details{
user_group: one element vector
data_area: vector of data areas
}
\examples{
# save access details to file
home <- Sys.getenv('HOME')

# create carnation data area if it doesn't exist
carnation_home <- file.path(home, 'carnation/data')
if(!dir.exists(carnation_home)) dir.create(carnation_home)

create_access_yaml(user = 'admin',
                   user_group = 'admin',
                   data_area = carnation_home)

# get current user access details
al <- read_access_yaml()

lst <- check_user_access(al, u='admin')

}
