% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{add_metadata}
\alias{add_metadata}
\title{Add metadata to counts data frame}
\usage{
add_metadata(df, coldata, exclude.intgroups)
}
\arguments{
\item{df}{data.frame with gene counts}

\item{coldata}{data.frame with metadata}

\item{exclude.intgroups}{metadata columns to ignore}
}
\value{
counts data frame with added metadata
}
\description{
Add metadata to counts data frame
}
\examples{
library(DESeq2)

# make example DESeq data set
dds <- makeExampleDESeqDataSet()

# extract counts and metadata
df <- assay(dds)
coldata <- colData(dds)

# get gene counts df
counts_df <- get_gene_counts(dds, paste0('gene', seq_len(10)))

# add metadata
counts_df <- add_metadata(counts_df, coldata, exclude.intgroups=NULL)

}
