% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmapR_subset.R
\name{readGctxMeta}
\alias{readGctxMeta}
\title{Parse row or column metadata from GCTX files}
\source{
\url{https://github.com/cmap/cmapR}
}
\usage{
readGctxMeta(
  gctx_path,
  dimension = "row",
  ids = NULL,
  set_annot_rownames = TRUE
)
}
\arguments{
\item{gctx_path}{the path to the GCTX file}

\item{dimension}{which metadata to read (row or column)}

\item{ids}{a character vector of a subset of row/column ids
for which to read the metadata}

\item{set_annot_rownames}{a boolean indicating whether to set the
\code{rownames} attribute of the returned \code{data.frame} to the
corresponding row/column ids.}
}
\value{
a \code{data.frame} of metadata
}
\description{
Parse row or column metadata from GCTX files
}
\seealso{
Other GCTX parsing functions: 
\code{\link{fix.datatypes}()},
\code{\link{processIds}()},
\code{\link{readGctxIds}()}
}
\concept{GCTX parsing functions}
\keyword{internal}
