% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drugSensitivity.R
\name{predictTargetingDrugs}
\alias{predictTargetingDrugs}
\title{Predict targeting drugs}
\usage{
predictTargetingDrugs(
  input,
  expressionDrugSensitivityCor,
  method = c("spearman", "pearson", "gsea"),
  geneSize = 150,
  isDrugActivityDirectlyProportionalToSensitivity = NULL,
  threads = 1,
  chunkGiB = 1,
  verbose = FALSE
)
}
\arguments{
\item{input}{\code{Named numeric vector} of differentially expressed genes
whose names are gene identifiers and respective values are a statistic that
represents significance and magnitude of differentially expressed genes
(e.g. t-statistics); or \code{character} of gene symbols composing a gene
set that is tested for enrichment in reference data (only used if
\code{method} includes \code{gsea})}

\item{expressionDrugSensitivityCor}{Matrix or character: correlation matrix
of gene expression (rows) and drug sensitivity (columns) across cell lines
or path to file containing such data; see
\code{\link{loadExpressionDrugSensitivityAssociation}()}.}

\item{method}{Character: comparison method (\code{spearman}, \code{pearson}
or \code{gsea}; multiple methods may be selected at once)}

\item{geneSize}{Numeric: number of top up-/down-regulated genes to use as
gene sets to test for enrichment in reference data; if a 2-length numeric
vector, the first index is the number of top up-regulated genes and the
second index is the number of down-regulated genes used to create gene
sets; only used if \code{method} includes \code{gsea} and if \code{input}
is not a gene set}

\item{isDrugActivityDirectlyProportionalToSensitivity}{Boolean: are the
values used for drug activity directly proportional to drug sensitivity?
If \code{NULL}, the argument \code{expressionDrugSensitivityCor} must have
a non-\code{NULL} value for attribute
\code{isDrugActivityDirectlyProportionalToSensitivity}.}

\item{threads}{Integer: number of parallel threads}

\item{chunkGiB}{Numeric: if second argument is a path to an HDF5 file
(\code{.h5} extension), that file is loaded and processed in chunks of a
given size in gibibytes (GiB); lower values decrease peak RAM usage (see
details below)}

\item{verbose}{Boolean: print additional details?}
}
\value{
Data table with correlation and/or GSEA score results
}
\description{
Identify compounds that may target the phenotype associated with a
user-provided differential expression profile by comparing such against a
correlation matrix of gene expression and drug sensitivity.
}
\section{Process data by chunks}{

  If a file path to a valid HDF5 (\code{.h5}) file is provided instead of a
  data matrix, that file can be loaded and processed in chunks of size
  \code{chunkGiB}, resulting in decreased peak memory usage.

  The default value of 1 GiB (1 GiB = 1024^3 bytes) allows loading chunks of ~10000 columns and
  14000 rows (\code{10000 * 14000 * 8 bytes / 1024^3 = 1.04 GiB}).
}

\section{GSEA score}{

  When \code{method = "gsea"}, weighted connectivity scores (WTCS) are
  calculated (\url{https://clue.io/connectopedia/cmap_algorithms}).
}

\examples{
# Example of a differential expression profile
data("diffExprStat")

# Load expression and drug sensitivity association derived from GDSC data
gdsc <- loadExpressionDrugSensitivityAssociation("GDSC 7")

# Predict targeting drugs on a differential expression profile
predictTargetingDrugs(diffExprStat, gdsc)
}
\seealso{
Other functions related with the prediction of targeting drugs: 
\code{\link{as.table.referenceComparison}()},
\code{\link{listExpressionDrugSensitivityAssociation}()},
\code{\link{loadExpressionDrugSensitivityAssociation}()},
\code{\link{plot.referenceComparison}()},
\code{\link{plotTargetingDrugsVSsimilarPerturbations}()}
}
\concept{functions related with the prediction of targeting drugs}
