% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drugSensitivity.R
\name{loadCTRPgeneExpression}
\alias{loadCTRPgeneExpression}
\alias{loadCTRPdrugSensitivity}
\alias{loadCTRPcompoundInfo}
\alias{loadNCI60geneExpression}
\alias{loadGDSC7file}
\alias{loadGDSC7cellLineInfo}
\alias{loadGDSC7compoundInfo}
\alias{loadGDSC7geneExpression}
\alias{loadGDSC7drugSensitivity}
\title{Load CTRP data}
\usage{
loadCTRPgeneExpression(
  geneExpressionFile = "CTRP 2.1/geneExpr.txt",
  geneInfoFile = "CTRP 2.1/geneInfo.txt",
  cellLineInfoFile = "CTRP 2.1/cellLineInfo.txt"
)

loadCTRPdrugSensitivity(
  drugSensitivityFile = "CTRP 2.1/drugSensitivity.txt",
  experimentFile = "CTRP 2.1/experimentInfo.txt",
  compoundFile = "CTRP 2.1/compoundInfo.txt"
)

loadCTRPcompoundInfo(compoundFile = "CTRP 2.1/compoundInfo.txt")

loadNCI60geneExpression(
  file = "NCI60/geneExpr.xls",
  cellLineInfoFile = "cellLineInfo.xls"
)

loadGDSC7file(file, filename, type, ...)

loadGDSC7cellLineInfo(file = "GDSC_7/cellLineInfo.xlsx")

loadGDSC7compoundInfo(file = "GDSC_7/compoundInfo.xlsx")

loadGDSC7geneExpression(file = "GDSC_7/geneExpr.txt")

loadGDSC7drugSensitivity(file = "GDSC_7/drugs.xlsx")
}
\arguments{
\item{geneExpressionFile}{Character: path to file with gene expression}

\item{geneInfoFile}{Character: path to file with gene information}

\item{cellLineInfoFile}{Character: path to file with cell line information}

\item{drugSensitivityFile}{Character: path to file with drug sensitivity}

\item{experimentFile}{Character: path to file with experiment information}

\item{compoundFile}{Character: path to file with compound information}

\item{file}{Character: file path}
}
\value{
Data frame
}
\description{
If given paths direct to non-existing files, those files will be downloaded
}
\keyword{internal}
