% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSignatures.R
\name{writeGMT}
\alias{writeGMT}
\title{Write microbe signatures to file in GMT format}
\usage{
writeGMT(sigs, gmt.file, ...)
}
\arguments{
\item{sigs}{A list of microbe signatures (character vectors of taxonomic
IDs).}

\item{gmt.file}{character. Path to output file in GMT format.}

\item{...}{Arguments passed on to cat()}
}
\value{
none, writes to file.
}
\description{
Functionality for writing microbe signatures to file in GMT
format.
}
\examples{
bsdb <- importBugSigDB()
sigs <- getSignatures(bsdb)
writeGMT(sigs, gmt.file = "signatures.gmt")
file.remove("signatures.gmt") 
}
\references{
GMT file format:
\url{http://www.broadinstitute.org/cancer/software/gsea/wiki/index.php/Data_formats}
}
