% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-helper.R
\name{ParseGeneric}
\alias{ParseGeneric}
\title{Generic parser for a description string.}
\usage{
ParseGeneric(description, acronym)
}
\arguments{
\item{description}{A description string from one of the entries.}

\item{acronym}{The acronym of the field. Can be found with \code{\link[=ShowFields]{ShowFields()}}.}
}
\value{
A \code{tibble} with columns: proteinID, description, fieldInfo,
commentary, and refID
}
\description{
Descriptions are generally structured as the following:
\itemize{
\item Protein information is included in '#'...#',
\item Literature citations are in '<...>',
\item Commentaries in '(...)', and
\item field-special information in '{...}'.
}

This function separates these fields into different columns.
}
\details{
The \code{description} column contains values extracted by BRENDA in each field.

The \code{fieldInfo} column contains different information in different fields:
\itemize{
\item In a \code{SYNONYMS} entry, it is either the source of the identifier, or part
of the description (a false positive).
\item In \code{KM_VALUE}, \code{TURNOVER_NUMBER} entries, it's the corresponding substrate.
}
}
\keyword{internal}
