% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{CleanECNumber}
\alias{CleanECNumber}
\title{Remove deleted and transferred EC numbers.}
\usage{
CleanECNumber(df)
}
\arguments{
\item{df}{A \code{tibble} generated by \code{\link[=ReadBrenda]{ReadBrenda()}}.}
}
\value{
A \code{tibble} with deleted and transferred entries moved to the bottom,
with columns:
\itemize{
\item ID being the deleted/transferred ID,
\item field being "TRANSFERRED_DELETED", and
\item description being the information included in the original ID column.
}
}
\description{
Some EC numbers have comments wrapped in parentheses. Most of
them are deleted (in this case we remove them) entries or transferred (in
this case we point to the new entry) entries.
}
\examples{
df <- ReadBrenda(system.file("extdata", "brenda_download_test.txt",
                          package = "brendaDb"))
brendaDb:::CleanECNumber(df)

}
\keyword{internal}
