#' brendaDb: the BRENDA enzyme database.
#'
#' brendaDb provides an R interface to download, clean and extract enzyme
#' information from the BRENDA database.
#'
#' The main aims of brendaDb include:
#' - Read text file downloaded from BRENDA into an R `tibble`
#' - Retrieve information for specific enzymes
#' - Query enzymes using their synonyms, gene symbols, etc.
#' - Query enzyme information for specific [BioCyc](https://biocyc.org) pathways
#'
#' To learn more about brendaDb, please refer to the vignette.
#' `browseVignettes(package = "brendaDb")`
#'
#' @useDynLib brendaDb
#' @importFrom Rcpp sourceCpp
"_PACKAGE"

#' Information fields and their corresponding acronyms.
#'
#' The RData file is generated by reading the entire BRENDA text file with
#' `ReadBrenda()`, and getting unique values in the `field` column. The acronyms
#' are extracted by the regex `^[A-Z_05]+`.
#'
#' @docType data
#' @keywords internal
#' @name acronyms
#' @usage data(acronyms)
#' @format A data.frame with 40 rows and 2 columns.
#' - field: field names in the BRENDA text file (all uppercase letters separated
#' by underscores). This could be used in the `fields` argument of the
#' `QueryBrenda()` function.
#' - acronym: acronyms used by the BRENDA file to indicate the fields.
"acronyms"
