% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hotspotter.R
\name{hotspotter}
\alias{hotspotter}
\title{Find hotspots of genomic events}
\usage{
hotspotter(gr.list, bw, pval = 1e-08)
}
\arguments{
\item{gr.list}{A list or \code{\link{GRangesList-class}} with \code{\link{GRanges-class}} object containing the coordinates of the genomic events.}

\item{bw}{Bandwidth used for kernel density estimation (see \code{\link[stats]{density}}).}

\item{pval}{P-value cutoff for hotspots.}
}
\value{
A \code{\link{GRanges-class}} object containing coordinates of hotspots with p-values.
}
\description{
Find hotspots of genomic events by using kernel \link{density} estimation.
}
\details{
The hotspotter uses \code{\link[stats]{density}} to perform a KDE. A p-value is calculated by comparing the density profile of the genomic events with the density profile of a randomly subsampled set of genomic events. Due to this random sampling, the result can vary for each function call, most likely for hotspots whose p-value is close to the specified \code{pval}.
}
\examples{
## Get example BreakPoint objects
exampleFolder <- system.file("extdata", "example_results", package="breakpointRdata")
exampleFiles <- list.files(exampleFolder, full.names=TRUE)
breakpoint.objects <- loadFromFiles(exampleFiles)
## Extract breakpoint coordinates
breaks <- lapply(breakpoint.objects, '[[', 'breaks')
## Get hotspot coordinates
hotspots <- hotspotter(gr.list=breaks, bw=1e6)

}
\author{
Aaron Taudt
}
