% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeBranchpointWindowForSNP.R
\name{makeBranchpointWindowForSNP}
\alias{makeBranchpointWindowForSNP}
\title{Makes a branchpointer formatted GRanges object from refsnp ids}
\usage{
makeBranchpointWindowForSNP(refSNP, mart.snp, exons, maxDist = 50,
  filter = TRUE)
}
\arguments{
\item{refSNP}{Vector of refsnp ids}

\item{mart.snp}{biomaRt mart object specifying the BioMart database and dataset to be used}

\item{exons}{GRanges containing exon co-ordinates.
Should be produced by gtfToExons()}

\item{maxDist}{maximum distance a SNP can be from an annotated 3' exon.}

\item{filter}{remove SNP queries prior to finding finding nearest exons?}
}
\value{
formatted SNP query GRanges
}
\description{
Searches Biomart for refsnp ids, and pulls genomic location and sequence identity information
Reformats alleles so each query has only one alternative allele
}
\examples{
smallExons <- system.file("extdata","gencode.v26.annotation.small.gtf",package = "branchpointer")
exons <- gtfToExons(smallExons)

mart.snp <- biomaRt::useMart("ENSEMBL_MART_SNP", dataset="hsapiens_snp", host="www.ensembl.org")
query <- makeBranchpointWindowForSNP("rs587776767", mart.snp, exons)
}
\author{
Beth Signal
}
