% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnem_main.r
\name{simulateStatesRecursive}
\alias{simulateStatesRecursive}
\title{Simulate states}
\usage{
simulateStatesRecursive(CNOlist, model, bString, NEMlist = NULL)
}
\arguments{
\item{CNOlist}{CNOlist object (see package CellNOptR), if available.}

\item{model}{Model object including the search space, if available.
See CellNOptR::preprocessing.}

\item{bString}{binary vector denoting the sub-graph given model}

\item{NEMlist}{NEMlist object only for devel}
}
\value{
return the truth tables for certain perturbation experiments
as a numeric matrix
}
\description{
simulates the activation pattern (truth table) of a hyper-graph and
annotated perturbation experiments
}
\examples{
sifMatrix <- rbind(c("A", 1, "B"), c("A", 1, "C"), c("B", 1, "D"),
c("C", 1, "D"))
temp.file <- tempfile(pattern="interaction",fileext=".sif")
write.table(sifMatrix, file = temp.file, sep = "\t",
row.names = FALSE, col.names = FALSE,
quote = FALSE)
PKN <- CellNOptR::readSIF(temp.file)
CNOlist <- dummyCNOlist("A", c("B","C","D"), maxStim = 1, maxInhibit = 2,
signal = c("A", "B","C","D"))
model <- CellNOptR::preprocessing(CNOlist, PKN, maxInputsPerGate = 100)
states <- simulateStatesRecursive(CNOlist, model,
rep(1, length(model$reacID)))
}
\author{
Martin Pirkl
}
