% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnem_main.r
\name{findResiduals}
\alias{findResiduals}
\title{Compute residuals}
\usage{
findResiduals(
  bString,
  CNOlist,
  model,
  fc = NULL,
  expression = NULL,
  egenes = NULL,
  parameters = list(cutOffs = c(0, 1, 0), scoring = c(0.1, 0.2, 0.9)),
  method = "s",
  sizeFac = 10^-10,
  main = "residuals for decoupled vertices",
  sub = paste0("green residuals are added effects (left positive,",
    " right negative) and red residuals are deleted ", "effects"),
  cut = TRUE,
  parallel = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{bString}{Binary vector denoting the network given a model}

\item{CNOlist}{CNOlist object (see package CellNOptR), if available.}

\item{model}{Model object including the search space, if available.
See CellNOptR::preprocessing.}

\item{fc}{m x l matrix of foldchanges of gene expression values or 
equivalent input
(normalized pvalues, logodds, ...) for m E-genes and l contrasts. If left 
NULL, the gene expression
data is used to calculate naive foldchanges.}

\item{expression}{Optional normalized m x l matrix of gene expression data 
for m E-genes and l experiments.}

\item{egenes}{list object; each list entry is named after an S-gene and
contains the names of egenes which are potential children}

\item{parameters}{parameters for discrete case (not recommended);
has to be a list with entries cutOffs and scoring:
cutOffs = c(a,b,c) with a (cutoff for real zeros),
b (cutoff for real effects),
c = -1 for normal scoring, c between 0 and
1 for keeping only relevant % of E-genes,
between -1 and 0 for keeping only a specific quantile of E-genes,
and c > 1 for keeping the top c E-genes;
scoring = c(a,b,c) with a (weight for real effects),
c (weight for real zeros),
b (multiplicator for effects/zeros between a and c);}

\item{method}{Scoring method can be "cosine", a correlation,
or a distance measure. See ?cor and ?dist for details.}

\item{sizeFac}{Size factor penelizing the hyper-graph size.}

\item{main}{Main title of the figure.}

\item{sub}{Subtitle of the figure.}

\item{cut}{If TRUE does not visualize experiments/S-genes which do
not have any residuals.}

\item{parallel}{Parallelize the search. An integer value specifies the
number of threads on the local machine or a list object as in list(c(1,2,3),
c("machine1", "machine2", "machine3")) specifies the threads distributed
on different machines (local or others).}

\item{verbose}{TRUE for verbose output}

\item{...}{additional parameters for epiNEM::HeatmapOP}
}
\value{
numeric matrices indicating experiments and/or genes, where the
network and the data disagree
}
\description{
calculates residuals (data and optimized network do not match) and
visualizes them
}
\examples{
sifMatrix <- rbind(c("A", 1, "B"), c("A", 1, "C"), c("B", 1, "D"),
c("C", 1, "D"))
temp.file <- tempfile(pattern="interaction",fileext=".sif")
write.table(sifMatrix, file = temp.file, sep = "\t",
row.names = FALSE, col.names = FALSE,
quote = FALSE)
PKN <- CellNOptR::readSIF(temp.file)
CNOlist <- dummyCNOlist("A", c("B","C","D"), maxStim = 1, maxInhibit = 2,
signal = c("A", "B","C","D"))
model <- CellNOptR::preprocessing(CNOlist, PKN, maxInputsPerGate = 100)
expression <- matrix(rnorm(nrow(slot(CNOlist, "cues"))*10), 10,
nrow(slot(CNOlist, "cues")))
fc <- computeFc(CNOlist, expression)
initBstring <- rep(0, length(model$reacID))
res <- bnem(search = "greedy", CNOlist = CNOlist, fc = fc, model = model,
parallel = NULL, initBstring = initBstring, draw = FALSE, verbose = FALSE,
maxSteps = Inf)
rownames(fc) <- seq_len(nrow(fc))
## val <- validateGraph(CNOlist = CNOlist, fc = fc, model = model,
## bString = res$bString, Egenes = 10, Sgene = 4)
residuals <- findResiduals(res$bString, CNOlist, model, fc = fc)
}
\author{
Martin Pirkl
}
