% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnem_main.r
\name{bnem}
\alias{bnem}
\title{Boolean Nested Effects Model main function}
\usage{
bnem(
  search = "greedy",
  fc = NULL,
  expression = NULL,
  egenes = NULL,
  pkn = NULL,
  design = NULL,
  stimuli = NULL,
  inhibitors = NULL,
  signals = NULL,
  CNOlist = NULL,
  model = NULL,
  sizeFac = 10^-10,
  NAFac = 1,
  parameters = list(cutOffs = c(0, 1, 0), scoring = c(0.1, 0.2, 0.9)),
  parallel = NULL,
  method = "cosine",
  relFit = FALSE,
  verbose = TRUE,
  reduce = TRUE,
  parallel2 = 1,
  initBstring = NULL,
  popSize = 100,
  pMutation = 0.5,
  maxTime = Inf,
  maxGens = Inf,
  stallGenMax = 10,
  relTol = 0.01,
  priorBitString = NULL,
  selPress = c(1.2, 1e-04),
  fit = "linear",
  targetBstring = "none",
  elitism = NULL,
  inversion = NULL,
  selection = c("t"),
  type = "SOCK",
  exhaustive = FALSE,
  delcyc = FALSE,
  seeds = 1,
  maxSteps = Inf,
  node = NULL,
  absorpII = TRUE,
  draw = TRUE,
  prior = NULL,
  maxInputsPerGate = 2
)
}
\arguments{
\item{search}{Type of search heuristic. Either "greedy", "genetic" or
"exhaustive". "greedy" uses a greedy algorithm to move through the local
neighbourhood of a initial hyper-graph. "genetic" uses a genetic algorithm.
"exhaustive" searches through the complete search space and is not
recommended.}

\item{fc}{m x l matrix of foldchanges of gene expression values or 
equivalent input
(normalized pvalues, logodds, ...) for m E-genes and l contrasts. If left 
NULL, the gene expression
data is used to calculate naive foldchanges.}

\item{expression}{Optional normalized m x l matrix of gene expression data 
for m E-genes and l experiments.}

\item{egenes}{list object; each list entry is named after an S-gene and
contains the names of egenes which are potential children}

\item{pkn}{Prior knowledge network as output by CellNOptR::readSIF.}

\item{design}{Optional n x l design matrix with n S-genes and l experiments.
If available. If kept NULL, bnem needs either stimuli, inhibitors or a
CNOlist object.}

\item{stimuli}{Character vector of stimuli names.}

\item{inhibitors}{Character vector of inhibitors.}

\item{signals}{Optional character vector of signals. Signals are S-genes,
which can directly regulate E-genes. If left NULL, all stimuli and
inhibitors are defined as signals.}

\item{CNOlist}{CNOlist object (see package CellNOptR), if available.}

\item{model}{Model object including the search space, if available.
See CellNOptR::preprocessing.}

\item{sizeFac}{Size factor penelizing the hyper-graph size.}

\item{NAFac}{factor penelizing NAs in the data.}

\item{parameters}{parameters for discrete case (not recommended);
has to be a list with entries cutOffs and scoring:
cutOffs = c(a,b,c) with a (cutoff for real zeros),
b (cutoff for real effects),
c = -1 for normal scoring, c between 0 and
1 for keeping only relevant % of E-genes,
between -1 and 0 for keeping only a specific quantile of E-genes,
and c > 1 for keeping the top c E-genes;
scoring = c(a,b,c) with a (weight for real effects),
c (weight for real zeros),
b (multiplicator for effects/zeros between a and c);}

\item{parallel}{Parallelize the search. An integer value specifies the
number of threads on the local machine or a list object as in list(c(1,2,3),
c("machine1", "machine2", "machine3")) specifies the threads distributed
on different machines (local or others).}

\item{method}{Scoring method can be "cosine", a correlation,
or a distance measure. See ?cor and ?dist for details.}

\item{relFit}{if TRUE a relative fit for each
E-gene is computed (not recommended)}

\item{verbose}{TRUE for verbose output}

\item{reduce}{if TRUE reduces the search space for exhaustive search}

\item{parallel2}{if TRUE parallelises the starts and not the search itself}

\item{initBstring}{Binary vector for the initial hyper-graph.}

\item{popSize}{Population size (only "genetic").}

\item{pMutation}{Probability between 0 and 1 for mutation (only "genetic").}

\item{maxTime}{Define a maximal time (seconds) for the search.}

\item{maxGens}{Maximal number of generations (only "genetic").}

\item{stallGenMax}{Maximum number of stall generations (only "genetic").}

\item{relTol}{Score tolerance for networks defined as optimal but with a
lower score as the real optimum (only "genetic").}

\item{priorBitString}{Binary vector defining hyper-edges which are added
to every hyper-graph. E.g. if you know hyper-edge 55 is definitly there and
to fix that, set priorBitString[55] <- 1 (only "genetic").}

\item{selPress}{Selection pressure between 1 and 2 (if fit="linear") and
greater 2 (for fit "nonlinear") for the stochastic universal sampling
(only "genetic").}

\item{fit}{"linear" or "nonlinear fit for stochastic universal sampling}

\item{targetBstring}{define a binary vector representing a network;
if this network is found, the computation stops}

\item{elitism}{Number of best hyper-graphs transferred to the next generation
(only "genetic").}

\item{inversion}{Number of worst hyper-graphs for which their binary strings
are inversed  (only "genetic").}

\item{selection}{"t" for tournament selection and "s" for stochastic
universal sampling (only "genetic").}

\item{type}{type of the paralellisation on multpile machines (default: 
"SOCK")}

\item{exhaustive}{If TRUE an exhaustive search is conducted if the genetic
algorithm would take longer (only "genetic").}

\item{delcyc}{If TRUE deletes cycles in all hyper-graphs (not recommended).}

\item{seeds}{how many starts for the greedy search? (default: 1); uses 
the n-dimensional cube (n = number of S-genes) to maximize search 
space coverage}

\item{maxSteps}{Maximal number of steps (only "greedy").}

\item{node}{vector of S-gene names, which are used in the greedy
search; if node = NULL all nodes are considered}

\item{absorpII}{Use inverse absorption (default: TRUE).}

\item{draw}{If TRUE draws the network evolution.}

\item{prior}{Binary vector. A 1 specifies hyper-edges which should not be
optimized (only "greedy").}

\item{maxInputsPerGate}{If no model is supplied, one is created with
maxInputsPerGate as maximum number of parents for each hyper-edge.}
}
\value{
List object including the optimized hyper-graph, its
corresponding binary vector for full hyper-graph and optimized scores.
}
\description{
This function takes a prior network and normalized perturbation data
as input and trains logical functions on that prior network
}
\examples{
sifMatrix <- rbind(c("A", 1, "B"), c("A", 1, "C"), c("B", 1, "D"),
c("C", 1, "D"))
temp.file <- tempfile(pattern="interaction",fileext=".sif")
write.table(sifMatrix, file = temp.file, sep = "\t",
row.names = FALSE, col.names = FALSE,
quote = FALSE)
PKN <- CellNOptR::readSIF(temp.file)
CNOlist <- dummyCNOlist("A", c("B","C","D"), maxStim = 1,
maxInhibit = 2, signals = c("A", "B","C","D"))
model <- CellNOptR::preprocessing(CNOlist, PKN, maxInputsPerGate = 100)
expression <- matrix(rnorm(nrow(slot(CNOlist, "cues"))*10), 10,
nrow(slot(CNOlist, "cues")))
fc <- computeFc(CNOlist, expression)
initBstring <- rep(0, length(model$reacID))
res <- bnem(search = "greedy", model = model, CNOlist = CNOlist,
fc = fc, pkn = PKN, stimuli = "A", inhibitors = c("B","C","D"),
parallel = NULL, initBstring = initBstring, draw = FALSE, verbose = FALSE,
maxSteps = Inf)
}
\seealso{
nem
}
\author{
Martin Pirkl
}
