% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segToGr.R
\name{segToGr}
\alias{segToGr}
\title{Import a segmentation file into GRanges object}
\usage{
segToGr(seg, genome = "hg19", name = "ID", score = "seg.mean")
}
\arguments{
\item{seg}{The .seg filename}

\item{genome}{Genome against which segments were annotated (DEFAULT: "hg19")}

\item{name}{.seg file column to use as $name metadata (DEFAULT: "ID")}

\item{score}{.seg file column to use as $score metadata
(DEFAULT: "seg.mean")}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{   A GRanges object
}\if{html}{\out{</div>}}
}
\description{
Reverse of grToSeg
}
\examples{

  clock <- getClock(model="horvathshrunk", genome="hg38")
  gr <- clock$gr

  df <- grToSeg(gr = gr, file = "test_grToSeg.seg")
  segs <- segToGr("test_grToSeg.seg", genome="hg38")

  if (file.exists("test_grToSeg.seg")) file.remove("test_grToSeg.seg")

}
\seealso{
grToSeg
}
