% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readEpibed.R
\name{readEpibed}
\alias{readEpibed}
\title{Read in and decode the RLE representation of the epibed format out of biscuit epiread}
\usage{
readEpibed(
  epibed,
  genome = NULL,
  chr = NULL,
  start = 1,
  end = 2^28,
  fragment_level = TRUE
)
}
\arguments{
\item{epibed}{The path to the epibed file (must be bgzip and tabix indexed)}

\item{genome}{What genome did this come from (e.g. 'hg19') (default: NULL)}

\item{chr}{Which chromosome to retrieve (default: NULL)}

\item{start}{The starting position for a region of interest (default: 1)}

\item{end}{The end position for a region of interest (default: 2^28)}

\item{fragment_level}{Whether to collapse reads to the fragment level (default: TRUE)}
}
\value{
A GRanges object
}
\description{
Read in and decode the RLE representation of the epibed format out of biscuit epiread
}
\examples{

epibed.nome <- system.file("extdata", "hct116.nome.epibed.gz", package="biscuiteer")
epibed.bsseq <- system.file("extdata", "hct116.bsseq.epibed.gz", package="biscuiteer")

epibed.nome.gr <- readEpibed(epibed = epibed.nome, genome = "hg19", chr = "chr1")
epibed.bsseq.gr <- readEpibed(epibed = epibed.bsseq, genome = "hg19", chr = "chr1")

}
