% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityFunctions.R
\name{searchFilterOptions}
\alias{searchFilterOptions}
\alias{listFilterOptions}
\title{List or search the options available for a specified filter.}
\usage{
searchFilterOptions(mart, filter, pattern = ".*")

listFilterOptions(mart, filter)
}
\arguments{
\item{mart}{object of class \code{Mart} created using the
\code{\link[=useMart]{useMart()}}, or \code{\link[=useEnsembl]{useEnsembl()}} functions}

\item{filter}{The name of the filter whose options should be listed or
searched.  You can list available filters via \code{\link[=listFilters]{listFilters()}}}

\item{pattern}{Character vector defining the regular expression
(\link[base:regex]{regex}) to be used for the search.  If left blank the
default is to use ".*" which will match everything.}
}
\description{
Some filters have a predefined list of values that can be used to search
them.  These functions give access to this list of options for a named
filter, so you can check in the case where your biomaRt query is not finding
anything.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
## Use the Ensembl human genes dataset
ensembl <- useEnsembl(
  biomart = "ENSEMBL_MART_ENSEMBL",
  dataset = "hsapiens_gene_ensembl"
)

## we can search for the name of a filter we're interested in e.g. 'phenotype'
## we need to use the name of the filter in the next function
searchFilters(ensembl, pattern = "phenotype")

## list all the options available to the 'phenotype_source' filter
listFilterOptions(mart = ensembl, filter = "phenotype_source")

## search the 'phenotype_description' filter for the term 'crohn'
searchFilterOptions(
  mart = ensembl,
  filter = "phenotype_description",
  pattern = "crohn"
)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=listFilters]{listFilters()}}
}
\author{
Mike Smith
}
\keyword{methods}
