% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomaRt.R
\name{attributePages}
\alias{attributePages}
\title{Gives a summary of the attribute pages}
\usage{
attributePages(mart)
}
\arguments{
\item{mart}{object of class Mart, created with the \code{\link[=useMart]{useMart()}} function.}
}
\description{
Attributes in BioMart databases are grouped together in attribute pages.
The \code{\link[=attributePages]{attributePages()}} function gives a summary of the attribute categories and
groups present in the BioMart.  These page names can be used to display only
a subset of the available attributes in the \code{\link[=listAttributes]{listAttributes()}} function.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
mart <- useMart(
  "ENSEMBL_MART_ENSEMBL",
  dataset = "hsapiens_gene_ensembl"
)
attributePages(mart)
\dontshow{\}) # examplesIf}
}
\author{
Steffen Durinck
}
\keyword{methods}
