% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiodbEntryFields.R
\name{BiodbEntryFields}
\alias{BiodbEntryFields}
\title{A class for handling description of all entry fields.}
\description{
A class for handling description of all entry fields.

A class for handling description of all entry fields.
}
\details{
The unique instance of this class is handle by the \code{\link{BiodbMain}}
class and accessed through the \code{getEntryFields()} method.
}
\examples{
# Getting information about the accession field:
mybiodb <- biodb::newInst()
entry.field <- mybiodb$getEntryFields()$get('accession')

# Test if a name is an alias of a field
mybiodb$getEntryFields()$isAlias('genesymbols')

# Test if a name is associated with a defined field
mybiodb$getEntryFields()$isDefined('name')

# Terminate instance.
mybiodb$terminate()

}
\seealso{
\code{\link{BiodbMain}} and child class
\code{\link{BiodbEntryField}}.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BiodbEntryFields-new}{\code{BiodbEntryFields$new()}}
\item \href{#method-BiodbEntryFields-notifyCfgUpdate}{\code{BiodbEntryFields$notifyCfgUpdate()}}
\item \href{#method-BiodbEntryFields-isAlias}{\code{BiodbEntryFields$isAlias()}}
\item \href{#method-BiodbEntryFields-formatName}{\code{BiodbEntryFields$formatName()}}
\item \href{#method-BiodbEntryFields-isDefined}{\code{BiodbEntryFields$isDefined()}}
\item \href{#method-BiodbEntryFields-checkIsDefined}{\code{BiodbEntryFields$checkIsDefined()}}
\item \href{#method-BiodbEntryFields-getRealName}{\code{BiodbEntryFields$getRealName()}}
\item \href{#method-BiodbEntryFields-get}{\code{BiodbEntryFields$get()}}
\item \href{#method-BiodbEntryFields-getFieldNames}{\code{BiodbEntryFields$getFieldNames()}}
\item \href{#method-BiodbEntryFields-getDatabaseIdField}{\code{BiodbEntryFields$getDatabaseIdField()}}
\item \href{#method-BiodbEntryFields-print}{\code{BiodbEntryFields$print()}}
\item \href{#method-BiodbEntryFields-define}{\code{BiodbEntryFields$define()}}
\item \href{#method-BiodbEntryFields-terminate}{\code{BiodbEntryFields$terminate()}}
\item \href{#method-BiodbEntryFields-clone}{\code{BiodbEntryFields$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryFields-new"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryFields-new}{}}}
\subsection{Method \code{new()}}{
New instance initializer. No BiodbEntryFields instance must be created
directly. Instead, call the getEntryFields() method of BiodbMain.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryFields$new(parent)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parent}}{The BiodbMain instance.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryFields-notifyCfgUpdate"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryFields-notifyCfgUpdate}{}}}
\subsection{Method \code{notifyCfgUpdate()}}{
Call back method called when a value is modified inside the configuration.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryFields$notifyCfgUpdate(k, v)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{k}}{The config key name.}

\item{\code{v}}{The value associated with the key.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryFields-isAlias"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryFields-isAlias}{}}}
\subsection{Method \code{isAlias()}}{
Tests if names are aliases.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryFields$isAlias(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{A character vector of names or aliases to test.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A logical vector, the same length as \code{name}, with TRUE
for name values that are an alias of a field, and FALSE otherwise."
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryFields-formatName"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryFields-formatName}{}}}
\subsection{Method \code{formatName()}}{
Format field name(s) for biodb format: set to lower case and remove
dot or underscore characters depending on configuration.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryFields$formatName(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{A character vector of names or aliases to test.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector of formatted names.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryFields-isDefined"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryFields-isDefined}{}}}
\subsection{Method \code{isDefined()}}{
Tests if names are defined fields.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryFields$isDefined(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{A character vector of names or aliases to test.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A logical vector, the same length as \code{name}, with TRUE
for name values that corresponds to a defined field.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryFields-checkIsDefined"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryFields-checkIsDefined}{}}}
\subsection{Method \code{checkIsDefined()}}{
Tests if names are valid defined fields. Throws an error if any name
does not correspond to a defined field.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryFields$checkIsDefined(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{A character vector of names or aliases to test.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryFields-getRealName"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryFields-getRealName}{}}}
\subsection{Method \code{getRealName()}}{
Gets the real names (main names) of fields. If some name is not found
neither in aliases nor in real names, an error is thrown.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryFields$getRealName(name, fail = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{A character vector of names or aliases.}

\item{\code{fail}}{Fails if name is unknown.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector, the same length as \code{name}, with the real
field name for each name given (i.e. each alias is replaced with the
real name).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryFields-get"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryFields-get}{}}}
\subsection{Method \code{get()}}{
Gets a BiodbEntryField instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryFields$get(name, drop = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{A character vector of names or aliases.}

\item{\code{drop}}{If TRUE and only one name has been submitted, returns a
single BiodbEntryField instance instead of a list.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A named list of BiodbEntryField instances. The names of the
list are the real names of the entry fields, thus they may be
different from the one provided inside the name argument.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryFields-getFieldNames"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryFields-getFieldNames}{}}}
\subsection{Method \code{getFieldNames()}}{
Gets the main names of all fields.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryFields$getFieldNames(type = NULL, computable = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{Set this parameter to a character vector in order to
return only the names of the fields corresponding to the types
specified.}

\item{\code{computable}}{If set to TRUE, returns only the names of computable
fields. If set to FALSE, returns only the names of fields that are not
computable.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector containing all selected field names.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryFields-getDatabaseIdField"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryFields-getDatabaseIdField}{}}}
\subsection{Method \code{getDatabaseIdField()}}{
Gets a database ID field.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryFields$getDatabaseIdField(database)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{database}}{The name (i.e.: Biodb ID) of a database.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\if{html}{\out{<div class="sourceCode">}}\preformatted{accession numbers) for this database.
}\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryFields-print"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryFields-print}{}}}
\subsection{Method \code{print()}}{
Prints information about the instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryFields$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryFields-define"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryFields-define}{}}}
\subsection{Method \code{define()}}{
Defines fields.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryFields$define(def)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{def}}{A named list of field definitions. The names of the list are the
main names of the fields.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryFields-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryFields-terminate}{}}}
\subsection{Method \code{terminate()}}{
Terminates the instance. This method will be called
automatically by the BiodbMain instance when you call
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryFields$terminate()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{BiodbMain}}{:terminate().}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbEntryFields-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbEntryFields-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbEntryFields$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
