test_that("use_longtests works as expected", {
  # Clean up any existing files/directories
  unlink(file.path(".BBSoptions"), recursive = TRUE, force = TRUE)
  unlink(file.path("longtests"), recursive = TRUE, force = TRUE)

  # Call the function
  use_longtests() |>
    expect_snapshot()

  # Check if the directories and files are created
  expect_true(dir.exists(file.path("longtests", "testthat")))
  expect_true(file.exists(file.path("longtests", "testthat.R")))
  expect_true(file.exists(".BBSoptions"))

  # Check the content of .BBSoptions
  lines <- readLines(".BBSoptions")
  expect_true(any(stringr::str_detect(lines, "RunLongTests: TRUE")))

  # Clean up
  unlink(file.path(".BBSoptions"), recursive = TRUE, force = TRUE)
  unlink(file.path("longtests"), recursive = TRUE, force = TRUE)
})

test_that("setup_bboptions works as expected", {
  # Clean up any existing files
  unlink(file.path(".BBSoptions"), recursive = TRUE, force = TRUE)

  # Call the function
  use_longtests() |>
    expect_snapshot()

  # Check if the file is created
  expect_true(file.exists(".BBSoptions"))

  # Check the content of .BBSoptions
  lines <- readLines(".BBSoptions")
  expect_true(any(stringr::str_detect(lines, "RunLongTests: TRUE")))

  # Clean up
  unlink(file.path(".BBSoptions"), recursive = TRUE, force = TRUE)
  unlink(file.path("longtests"), recursive = TRUE, force = TRUE)
})

test_that("setup_bboptions handles existing .BBSoptions with RunLongTests: FALSE", {
  # Clean up any existing files
  unlink(file.path(".BBSoptions"), recursive = TRUE, force = TRUE)

  # Create a .BBSoptions file with RunLongTests: FALSE
  writeLines(
    c("# Generated by biocroxytest: do not edit by hand!", "RunLongTests: FALSE"),
    ".BBSoptions"
  )

  # Call the function
  use_longtests() |>
    expect_snapshot()

  # Check if the file is created
  expect_true(file.exists(".BBSoptions"))

  # Check the content of .BBSoptions
  lines <- readLines(".BBSoptions")
  expect_true(any(stringr::str_detect(lines, "RunLongTests: TRUE")))

  # Clean up
  unlink(file.path(".BBSoptions"), recursive = TRUE, force = TRUE)
  unlink(file.path("longtests"), recursive = TRUE, force = TRUE)
})

test_that("setup_bboptions handles existing .BBSoptions with RunLongTests: TRUE", {
  # Clean up any existing files
  unlink(file.path(".BBSoptions"), recursive = TRUE, force = TRUE)

  # Create a .BBSoptions file with RunLongTests: FALSE
  writeLines(
    c("# Generated by biocroxytest: do not edit by hand!", "RunLongTests: TRUE"),
    ".BBSoptions"
  )

  # Call the function
  use_longtests() |>
    expect_snapshot()

  # Check if the file is created
  expect_true(file.exists(".BBSoptions"))

  # Check the content of .BBSoptions
  lines <- readLines(".BBSoptions")
  expect_true(any(stringr::str_detect(lines, "RunLongTests: TRUE")))

  # Clean up
  unlink(file.path(".BBSoptions"), recursive = TRUE, force = TRUE)
  unlink(file.path("longtests"), recursive = TRUE, force = TRUE)
})

test_that("setup_bboptions handles existing .BBSoptions with no RunLongTests correctly", {
  # Clean up any existing files
  unlink(file.path(".BBSoptions"), recursive = TRUE, force = TRUE)

  # Create a .BBSoptions file with no RunLongTests
  writeLines(
    c("# Generated by biocroxytest: do not edit by hand!"),
    ".BBSoptions"
  )

  # Call the function
  use_longtests() |>
    expect_snapshot()

  # Check if the file is created
  expect_true(file.exists(".BBSoptions"))

  # Check the content of .BBSoptions
  lines <- readLines(".BBSoptions")
  expect_true(any(stringr::str_detect(lines, "RunLongTests: TRUE")))

  # Clean up
  unlink(file.path(".BBSoptions"), recursive = TRUE, force = TRUE)
  unlink(file.path("longtests"), recursive = TRUE, force = TRUE)
})

test_that("use_longtests works as expected when test folder exists", {

  # Clean up any existing files
  unlink(file.path("longtests"), recursive = TRUE, force = TRUE)
  unlink(file.path(".BBSoptions"), recursive = TRUE, force = TRUE)

  # Create a tests folder
  dir.create(file.path("tests", "testthat"), recursive = TRUE, showWarnings = FALSE)
  '
      # This file is part of the standard setup for testthat.
      # It is recommended that you do not modify it.
      #
      # Where should you do additional test configuration?
      # Learn more about the roles of various files in:
      # * https://r-pkgs.org/testing-design.html#sec-tests-files-overview
      # * https://testthat.r-lib.org/articles/special-files.html

      library(testthat)
      library(biocroxytest)

      test_check("biocroxytest")
    ' |> writeLines(file.path("tests", "testthat.R"))

  # Call the function
  use_longtests() |>
    expect_snapshot()

  # Check if the directories and files are created
  expect_true(dir.exists(file.path("longtests", "testthat")))
  expect_true(file.exists(file.path("longtests", "testthat.R")))
  expect_true(file.exists(".BBSoptions"))

  # Check the content of .BBSoptions
  lines <- readLines(".BBSoptions")
  expect_true(any(stringr::str_detect(lines, "RunLongTests: TRUE")))

  # Clean up
  unlink(file.path(".BBSoptions"), recursive = TRUE, force = TRUE)
  unlink(file.path("longtests"), recursive = TRUE, force = TRUE)
  unlink(file.path("tests"), recursive = TRUE, force = TRUE)
})

