test_that("made_by_biocroxytest works correctly", {
  # Set up
  temp_dir <- paste0(tempdir(), "/longtests/testthat")
  dir.create(temp_dir, recursive = TRUE, showWarnings = FALSE)
  path <- here::here(temp_dir, "test-biocroxytest-example.R")

  # Test case 1: File exists, name matches, header matches
  writeLines("# Generated by biocroxytest: do not edit by hand!", path)
  expect_true(made_by_biocroxytest(path))

  # Test case 2: File exists, name matches, header does not match
  writeLines("# Not generated by biocroxytest", path)
  expect_false(made_by_biocroxytest(path))

  # Test case 3: File does not exist
  expect_true(made_by_biocroxytest("test-biocroxytest-nonexistent.R"))

  # Test case 4: File exists, name does not match
  path <- here::here(temp_dir, "test-example.R")
  writeLines("#. Generated by biocroxytest", path)
  expect_true(made_by_biocroxytest(path))
})
