% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_longtests_rcolet.R
\name{process_testfiles}
\alias{process_testfiles}
\title{Process test files for 'longtests'}
\usage{
process_testfiles(
  testfiles,
  indent_code = FALSE,
  add_testthat_boilerplate = FALSE,
  add_context_header = FALSE
)
}
\arguments{
\item{testfiles}{A named list of test files, where the names are the paths of
the files.}

\item{indent_code}{A logical value indicating whether to indent the code in
the tests.}

\item{add_testthat_boilerplate}{A logical value indicating whether to add a
'test_that' boilerplate to the tests.}

\item{add_context_header}{A logical value indicating whether to add a
'context' line to the header.}
}
\value{
A named list of content strings for the test files.
}
\description{
This is an internal function that processes a list of test files for
'longtests'. It loops over each test file and extracts the 'longtests' and
'functionname' fields. It then prepares the tests, optionally indents the
code, and formats the tests into a string with an optional 'test_that'
boilerplate. The function also constructs a header for the content, including
a 'context' line if specified. The resulting content strings are returned in
a named list, with the names being the paths of the test files.
}
\keyword{internal}
