% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longtests_rcolet.R
\name{longtests_roclet}
\alias{longtests_roclet}
\title{Roclet for Long Tests}
\usage{
longtests_roclet()
}
\value{
A roclet that can be used with \code{roxygen2} to process code blocks
marked with \verb{@longtests}. This roclet will produce a set of test files in a
separate directory, which can be run independently of the rest of your test
suite.
}
\description{
This roclet is used to identify and process code blocks in your documentation
that are marked with \verb{@longtests}. The \code{longtests_roclet} function creates a
new roclet, which is a plugin to the \code{roxygen2} package. Roclets are
responsible for parsing the R scripts of a package and producing the relevant
documentation files.
}
\details{
The \code{longtests_roclet} specifically looks for code blocks in your
documentation that are annotated with the \verb{@longtests} tag. These code blocks
should contain tests that take a long time to run, and thus cannot be
included in the regular test suite of the package.

When you run \code{roxygen2::roxygenise} with the \code{longtests_roclet}, it will
extract these long tests from your documentation and save them in a separate
directory. This allows you to run these long tests separately from the rest
of your tests, for example, on a continuous integration server that is set up
to run long tests.
}
\examples{
# Create a new roclet
longtests_roclet()
}
