% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping.R
\name{bbMapping}
\alias{bbMapping}
\title{Chain mapping and filtering}
\usage{
bbMapping(terms, mapfilter, page = NULL, source = NULL, lite = TRUE,
  limit = 1000, inattrs = NULL, attrs = NULL,
  showInputColumn = FALSE)
}
\arguments{
\item{terms}{Input terms for the mapping. Same with search functionality they can be comma seperated identifers or keywords}

\item{mapfilter}{Mapping query which consist of map and optional filter functions in the form of map(dataset).filter(Boolean query expression)
The boolean expressions are based on datasets attributes and dataset attributes can be list with bbAttr function.
Dataset attributes which used in the filters starts with their dataset name. In biobtree boolean expressions
feature has been implemented via Google common expression language so its full capability can be checked in its documentation.}

\item{page}{Optional parameter works similar with bbSearch page paramter.}

\item{source}{Optional dataset identifiers for searching input terms within the given dataset.}

\item{lite}{By default it is TRUE and allow function return quickly with data.frame with mapping identifiers and attributes. If set to TRUE function return raw results converted from json.}

\item{limit}{Limits the number of mapping results. By default without any limit all the results returned.}

\item{inattrs}{Optional comma seperated attribute names for input identifiers and if available their values includes in result data.frame}

\item{attrs}{Optional comma seperated attribute names for mapping identifiers and if available their values includes in result data.frame}

\item{showInputColumn}{Optional logical parameter to show the input identifers in the result data.frame}
}
\value{
returns mapping results in data.frame by default if lite set it true returns json object
}
\description{
Chain mapping identifiers or keywords with filtering and retrieving attributes if available.
}
\examples{
bbStart()

bbMapping("tpi1",'map(uniprot)')

bbMapping("shh",'map(ensembl)')

\dontrun{
# run these examples with building the default dataset with bbBuildData()
#Map protein to its go terms and retrieve go term types
bbMapping("AT5G3_HUMAN",'map(go)',attrs = "type")

#Map protein to its go terms with filter by its type and retrieve their types
bbMapping("AT5G3_HUMAN",'map(go).filter(go.type=="biological_process")',attrs = "type")

#Map gene names to exon identifiers and retrieve the region
bbMapping("ATP5MC3,TP53",'map(transcript).map(exon)',attrs = "seq_region_name")

#Map Affymetrix identifiers to Ensembl identifiers and gene names
bbMapping("202763_at,213596_at,209310_s_at",source ="affy_hg_u133_plus_2"
,'map(transcript).map(ensembl)',attrs = "name")

}

}
\author{
Tamer Gur
}
