% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\docType{methods}
\name{annotatedData}
\alias{annotatedData}
\alias{K}
\alias{N}
\alias{R}
\alias{A}
\alias{phi}
\alias{treatment_group}
\alias{llk}
\alias{tau}
\alias{hidden_states}
\alias{chromosome_number}
\alias{AUC}
\alias{uncertainty}
\alias{model_parameters}
\alias{threshold}
\alias{annotatedData,betaHMMResults-method}
\alias{annotatedData,threshold_Results-method}
\alias{K,RangedSummarizedExperiment-method}
\alias{K,betaHMMResults-method}
\alias{K,dmcResults-method}
\alias{K,threshold_Results-method}
\alias{K,NULL-method}
\alias{N,RangedSummarizedExperiment-method}
\alias{N,betaHMMResults-method}
\alias{N,dmcResults-method}
\alias{N,NULL-method}
\alias{R,RangedSummarizedExperiment-method}
\alias{R,betaHMMResults-method}
\alias{R,dmcResults-method}
\alias{R,NULL-method}
\alias{A,RangedSummarizedExperiment-method}
\alias{A,betaHMMResults-method}
\alias{A,NULL-method}
\alias{tau,RangedSummarizedExperiment-method}
\alias{tau,betaHMMResults-method}
\alias{tau,NULL-method}
\alias{phi,RangedSummarizedExperiment-method}
\alias{phi,betaHMMResults-method}
\alias{phi,threshold_Results-method}
\alias{phi,NULL-method}
\alias{llk,RangedSummarizedExperiment-method}
\alias{llk,betaHMMResults-method}
\alias{llk,NULL-method}
\alias{treatment_group,RangedSummarizedExperiment-method}
\alias{treatment_group,betaHMMResults-method}
\alias{treatment_group,dmcResults-method}
\alias{treatment_group,NULL-method}
\alias{hidden_states,RangedSummarizedExperiment-method}
\alias{hidden_states,betaHMMResults-method}
\alias{hidden_states,threshold_Results-method}
\alias{hidden_states,NULL-method}
\alias{model_parameters,RangedSummarizedExperiment-method}
\alias{model_parameters,threshold_Results-method}
\alias{model_parameters,NULL-method}
\alias{threshold,RangedSummarizedExperiment-method}
\alias{threshold,threshold_Results-method}
\alias{threshold,NULL-method}
\alias{chromosome_number,RangedSummarizedExperiment-method}
\alias{chromosome_number,betaHMMResults-method}
\alias{chromosome_number,dmrResults-method}
\alias{chromosome_number,NULL-method}
\alias{AUC,RangedSummarizedExperiment-method}
\alias{AUC,dmcResults-method}
\alias{AUC,NULL-method}
\alias{uncertainty,RangedSummarizedExperiment-method}
\alias{uncertainty,dmcResults-method}
\alias{uncertainty,NULL-method}
\title{Accessors for the betaHMM package.}
\usage{
annotatedData(object)

K(object)

N(object)

R(object)

A(object)

phi(object)

treatment_group(object)

llk(object)

tau(object)

hidden_states(object)

chromosome_number(object)

AUC(object)

uncertainty(object)

model_parameters(object)

threshold(object)

\S4method{annotatedData}{betaHMMResults}(object)

\S4method{annotatedData}{threshold_Results}(object)

\S4method{K}{RangedSummarizedExperiment}(object)

\S4method{K}{betaHMMResults}(object)

\S4method{K}{dmcResults}(object)

\S4method{K}{threshold_Results}(object)

\S4method{K}{`NULL`}(object)

\S4method{N}{RangedSummarizedExperiment}(object)

\S4method{N}{betaHMMResults}(object)

\S4method{N}{dmcResults}(object)

\S4method{N}{`NULL`}(object)

\S4method{R}{RangedSummarizedExperiment}(object)

\S4method{R}{betaHMMResults}(object)

\S4method{R}{dmcResults}(object)

\S4method{R}{`NULL`}(object)

\S4method{A}{RangedSummarizedExperiment}(object)

\S4method{A}{betaHMMResults}(object)

\S4method{A}{`NULL`}(object)

\S4method{tau}{RangedSummarizedExperiment}(object)

\S4method{tau}{betaHMMResults}(object)

\S4method{tau}{`NULL`}(object)

\S4method{treatment_group}{RangedSummarizedExperiment}(object)

\S4method{treatment_group}{betaHMMResults}(object)

\S4method{treatment_group}{dmcResults}(object)

\S4method{treatment_group}{`NULL`}(object)

\S4method{llk}{RangedSummarizedExperiment}(object)

\S4method{llk}{betaHMMResults}(object)

\S4method{llk}{`NULL`}(object)

\S4method{phi}{RangedSummarizedExperiment}(object)

\S4method{phi}{betaHMMResults}(object)

\S4method{phi}{threshold_Results}(object)

\S4method{phi}{`NULL`}(object)

\S4method{hidden_states}{RangedSummarizedExperiment}(object)

\S4method{hidden_states}{betaHMMResults}(object)

\S4method{hidden_states}{threshold_Results}(object)

\S4method{hidden_states}{`NULL`}(object)

\S4method{chromosome_number}{RangedSummarizedExperiment}(object)

\S4method{chromosome_number}{betaHMMResults}(object)

\S4method{chromosome_number}{dmrResults}(object)

\S4method{chromosome_number}{`NULL`}(object)

\S4method{AUC}{RangedSummarizedExperiment}(object)

\S4method{AUC}{dmcResults}(object)

\S4method{AUC}{`NULL`}(object)

\S4method{uncertainty}{RangedSummarizedExperiment}(object)

\S4method{uncertainty}{dmcResults}(object)

\S4method{uncertainty}{`NULL`}(object)

\S4method{model_parameters}{RangedSummarizedExperiment}(object)

\S4method{model_parameters}{threshold_Results}(object)

\S4method{model_parameters}{`NULL`}(object)

\S4method{threshold}{RangedSummarizedExperiment}(object)

\S4method{threshold}{threshold_Results}(object)

\S4method{threshold}{`NULL`}(object)
}
\arguments{
\item{object}{a \code{betaHMMResults}/ \code{dmcResults}/
\code{threshold_Results} object.}
}
\value{
Output varies depending on the method.
}
\description{
The accessor methods for accessing the betaHMMResults/ dmcResults/
dmrResults/ threshold_Results metadata.
}
\examples{
## Use simulated data for the betaHMM workflow example
set.seed(12345)

## read files
data(sample_methylation_file)
data(sample_annotation_file)
# Run betaHMM function
beta_out <- betaHMM(sample_methylation_file[1:50,],
                    sample_annotation_file[1:50,],
                    M = 3, N = 4, R = 2,iterations=2,
                    parallel_process = FALSE, seed = 12345,
                    treatment_group = c("Benign","Tumour"))

## Run dmc_identification function
dmc_out <- dmc_identification(beta_out)

# Run dmr_identification function
dmr_out <- dmr_identification(dmc_out, parallel_process = FALSE)

# Plot functions
# Get the AUC values calculated for each hidden state
AUC_chr <- AUC(dmc_out)

## plot the uncertainty for each hidden state
plot(beta_out, chromosome = "1", what = "uncertainty")

}
