% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadIntoMemory.R
\name{loadIntoMemory}
\alias{loadIntoMemory}
\title{Load a TileDB matrix into memory}
\usage{
loadIntoMemory(
  x,
  cache.size = getAutoBlockSize(),
  num.threads = 1,
  concurrency.level = NULL
)
}
\arguments{
\item{x}{A \pkg{TileDBArray}-derived matrix or seed object.}

\item{cache.size}{Integer scalar specifying the size of the cache in bytes during data extraction from a TileDB matrix.}

\item{num.threads}{Integer scalar specifying the number of threads to use outside of the TileDB library.}

\item{concurrency.level}{Integer scalar specifying the number of threads that can be used by the TileDB library.
See the option of the same name in \code{\link{initializeOptions}} for details.}
}
\value{
An external pointer that can be used in \pkg{tatami}-based functions.
}
\description{
Load a TileDB-backed matrix into memory as an external pointer to a \pkg{tatami}-compatible representation.
This differs from the (default) behavior of \code{\link{initializeCpp}}, which only loads slices of the matrix on request.
}
\examples{
library(TileDBArray)
y <- matrix(runif(1000), ncol=20, nrow=50)
z <- as(y, "TileDBArray")
ptr <- loadIntoMemory(z)

}
\author{
Aaron Lun
}
