% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R
\name{demultiplexMetrics}
\alias{demultiplexMetrics}
\title{Gather demultiplexing metrics from a Run (using Run's DemultiplexingStats.xml file).}
\usage{
demultiplexMetrics(bcl2fastqparams)
}
\arguments{
\item{bcl2fastqparams}{A BCL2FastQparams object as created by BCL2FastQparams() constructor.}
}
\value{
A list of length two containing the full demultiplexing metrics from a Run (using Run's DemultiplexingStats.xml file). Contains an unsummarised data.frame and demultiplexing metrics filtered to per Sample metrics
}
\description{
Gather demultiplexing metrics from a Run (using Run's DemultiplexingStats.xml file).
}
\examples{
fileLocations <- system.file("extdata",package="basecallQC")
runXML <- dir(fileLocations,pattern="runParameters.xml",full.names=TRUE)
config <- dir(fileLocations,pattern="config.ini",full.names=TRUE)
sampleSheet <- dir(fileLocations,pattern="*\\\\.csv",full.names=TRUE)
outDir <- file.path(fileLocations,"Runs/161105_D00467_0205_AC9L0AANXX/C9L0AANXX/")
bcl2fastqparams <- BCL2FastQparams(runXML,config,runDir=getwd(),outDir,verbose=FALSE)
demuxMetrics <- demultiplexMetrics(bcl2fastqparams)
}
