% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readWrite.R
\name{writeBambuOutput}
\alias{writeBambuOutput}
\title{Write Bambu results to GTF and transcript/gene-count files}
\usage{
writeBambuOutput(se, path, prefix = "")
}
\arguments{
\item{se}{a \code{\link{SummarizedExperiment}} object 
from \code{\link{bambu}}.}

\item{path}{the destination of the output files 
(gtf, transcript counts, and gene counts)}

\item{prefix}{the prefix of the output files}
}
\description{
Write Bambu results to GTF and transcript/gene-count files
}
\details{
The function will write the output from Bambu to files. The 
annotations will be written to a .gtf file, transcript counts (total counts, 
CPM, full-length counts, partial-length counts, and unique counts) and gene counts
will be written to .txt files.
}
\examples{
se <- readRDS(system.file("extdata",
    "seOutput_SGNex_A549_directRNA_replicate5_run1_chr9_1_1000000.rds",
    package = "bambu"
))
path <- tempdir()
writeBambuOutput(se, path)
}
