% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/23_impute.R
\name{split_samples}
\alias{split_samples}
\alias{cbind_imputed}
\alias{split_features}
\title{Split samples}
\usage{
split_samples(object, by = "subgroup")

cbind_imputed(objlist)

split_features(object, by)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{by}{svar to split by (string)}

\item{objlist}{SummarizedExperiment list}
}
\value{
SummarizedExperiment list
}
\description{
Split samples by svar
}
\examples{
file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
object <- read_metabolon(file)
objlist <- split_features(object, by = 'PLATFORM')
objlist <- split_samples(object, 'Diabetes')
objlist \%<>\% Map(impute, .)
object <- cbind_imputed(objlist)
}
