% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_read_omics.R
\name{merge_sdata}
\alias{merge_sdata}
\alias{merge_sdt}
\alias{merge_fdata}
\alias{merge_fdt}
\title{Merge sample/feature dt}
\usage{
merge_sdata(
  object,
  dt,
  by.x = "sample_id",
  by.y = names(dt)[1],
  all.x = TRUE,
  verbose = TRUE
)

merge_sdt(
  object,
  dt,
  by.x = "sample_id",
  by.y = "sample_id",
  all.x = TRUE,
  verbose = TRUE
)

merge_fdata(
  object,
  dt,
  by.x = "feature_id",
  by.y = names(dt)[1],
  all.x = TRUE,
  verbose = TRUE
)

merge_fdt(
  object,
  dt,
  by.x = "feature_id",
  by.y = "feature_id",
  all.x = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{dt}{data.frame, data.table, DataFrame}

\item{by.x}{string : object mergevar}

\item{by.y}{string : df mergevar}

\item{all.x}{TRUE / FALSE : whether to keep samples / features without annotation}

\item{verbose}{TRUE / FALSE : whether to msg}
}
\value{
SummarizedExperiment
}
\description{
Merge sample/feature dt
}
\examples{
file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
object <- read_metabolon(file)
sdt(object)
sdt(merge_sdt(object, data.table(sample_id = object$sample_id,
                                    number = seq_along(object$sample_id))))
}
