% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphic.R
\name{dtMotifMatch}
\alias{dtMotifMatch}
\title{Compute the augmented matching subsequence on SNP and reference allele
s.}
\usage{
dtMotifMatch(snp.tbl, motif.scores, snpids = NULL, motifs = NULL,
  motif.lib, ncores = 2)
}
\arguments{
\item{snp.tbl}{A data.frame with the following information:
\tabular{cc}{
snpid \tab SNP id.\cr
ref_seq \tab Reference allele nucleobase sequence.\cr
snp_seq \tab SNP allele nucleobase sequence.\cr
ref_seq_rev \tab Reference allele nucleobase sequence on the reverse 
strand.\cr
snp_seq_rev \tab SNP allele nucleobase sequence on the reverse strand.\cr}}

\item{motif.scores}{A data.frame with the following information:
\tabular{cc}{
motif \tab Name of the motif.\cr
motif_len \tab Length of the motif.\cr
ref_start, ref_end, ref_strand \tab Location of the best matching subsequence
 on the reference allele.\cr
snp_start, snp_end, snp_strand \tab Location of the best matching subsequence
 on the SNP allele.\cr
log_lik_ref \tab Log-likelihood score for the reference allele.\cr
log_lik_snp \tab Log-likelihood score for the SNP allele.\cr
log_lik_ratio \tab The log-likelihood ratio.\cr
log_enhance_odds \tab Difference in log-likelihood ratio between SNP allele 
and reference allele based on the best matching subsequence on the reference 
allele.\cr
log_reduce_odds \tab Difference in log-likelihood ratio between reference 
allele and SNP allele based on the best matching subsequence on the SNP 
allele.\cr
}}

\item{snpids}{A subset of snpids to compute the subsequences. Default: NULL, 
when all snps are computed.}

\item{motifs}{A subset of motifs to compute the subsequences. Default: NULL, 
when all motifs are computed.}

\item{motif.lib}{A list of named position weight matrices.}

\item{ncores}{The number of cores used for parallel computing. Default: 10}
}
\value{
A data.frame containing all columns from the function, 
\code{\link{MatchSubsequence}}. In addition, the following columns are added:
\tabular{ll}{
snp_ref_start, snp_ref_end, snp_ref_length \tab Location and Length of the 
best matching augmented subsequence on both the reference and SNP allele.\cr
ref_aug_match_seq_forward \tab Best matching augmented subsequence or its 
corresponding sequence to the forward strand on the reference allele.\cr 
snp_aug_match_seq_forward \tab Best matching augmented subsequence or its 
corresponding sequence to the forward strand on the SNP allele.\cr 
ref_aug_match_seq_reverse \tab Best matching augmented subsequence or its 
corresponding sequence to the reverse strand on the reference allele.\cr 
snp_aug_match_seq_reverse \tab Best matching augmented subsequence or its 
corresponding sequence to the reverse strand on the SNP allele.\cr 
ref_location \tab SNP location of the best matching augmented subsequence on 
the reference allele. Starting from zero. \cr
snp_location \tab SNP location of the best matching augmented subsequence on 
the SNP allele. Starting from zero. \cr
ref_extra_pwm_left \tab Left extra unmatching position on the best matching 
augmented subsequence of the reference allele. \cr
ref_extra_pwm_right \tab Right extra unmatching position on the best matching
 augmented subsequence of the reference allele. \cr
snp_extra_pwm_left \tab Left extra unmatching position on the best matching 
augmented subsequence of the SNP allele. \cr
snp_extra_pwm_right \tab Right extra unmatching position on the best matching
 augmented subsequence of the SNP allele. \cr
}
}
\description{
Calculate the best matching augmented subsequences on both SNP 
and reference alleles for motifs. Obtain extra unmatching position on the 
best matching augmented subsequence of the reference and SNP alleles.
}
\examples{
data(example)
dtMotifMatch(motif_scores$snp.tbl, motif_scores$motif.scores, 
motif.lib = motif_library)
}
\author{
Sunyoung Shin\email{sunyoung.shin@utdallas.edu}
}
