% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{artmsQuantification}
\alias{artmsQuantification}
\title{Relative quantification using MSstats}
\usage{
artmsQuantification(
  yaml_config_file,
  data_object = FALSE,
  printPDF = TRUE,
  printTables = TRUE,
  display_msstats = FALSE,
  return_results_object = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{yaml_config_file}{(char, required) The yaml file name and location}

\item{data_object}{(logical) flag to indicate whether the configuration file
is a string to a file that should be opened or config object (yaml).
Default is \code{FALSE}. Choose \code{TRUE} if \code{yaml_config_file} is a yaml object}

\item{printPDF}{(logical) if \code{TRUE} (default), prints out pdf}

\item{printTables}{(logical) \code{TRUE} (default) print results tables}

\item{display_msstats}{(logical) if \code{TRUE}, prints MSstats outputs (default is \code{FALSE})}

\item{return_results_object}{(logical) Default is \code{FALSE}.
If \code{TRUE}, it returns a list of data frames with MSstats results, including:
\itemize{
\item \code{comparisonResult}: comparison results
\item \code{ModelQC}
\item \code{FittedModel}: fit model details
\item \code{power}: power calculations
\item \code{sample_size}: sample size estimations
}}

\item{verbose}{(logical) \code{TRUE} (default) shows function messages}
}
\value{
The relative quantification of the conditions and comparisons
specified in the keys/contrast file resulting from running MSstats, in
addition to quality control plots (if selected)
}
\description{
Relative quantification using MSstats including:
\itemize{
\item plots
\item quantifications (log2fc, pvalues, etc)
\item normalized abundance values
}
}
\examples{
# Recommended
# artmsQuantification(yaml_config_file = "your-config-file.yaml")

# Example to test this function using the example dataset available in artMS
# Step 1: Add evidence, keys, and contrast to configuration object
artms_data_ph_config$files$evidence <- artms_data_ph_evidence
artms_data_ph_config$files$keys <- artms_data_ph_keys
artms_data_ph_config$files$contrasts <- artms_data_ph_contrast

# Step 2: Run the quantification step
quant_results <- artmsQuantification(yaml_config_file = artms_data_ph_config, 
                                     data_object = TRUE, 
                                     display_msstats = FALSE,
                                     printPDF = FALSE,
                                     printTables = FALSE)
# Check the list of data frames "quant_results". Nothing should be printed out. 
}
\keyword{driver,}
\keyword{function}
\keyword{main,}
