% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anota2seqAllGenerics.R, R/anota2seqMethods.R
\docType{methods}
\name{anota2seqGetThresholds}
\alias{anota2seqGetThresholds}
\alias{anota2seqGetThresholds,Anota2seqDataSet-method}
\title{Get filtering criteria thresholds}
\usage{
anota2seqGetThresholds(object, analysis, selContrast)

\S4method{anota2seqGetThresholds}{Anota2seqDataSet}(object, analysis, 
  selContrast)
}
\arguments{
\item{object}{An Anota2seqDataSet.}

\item{analysis}{A vector containing "translated mRNA", "total mRNA",
"translation" or "buffering" specifying for which analysis the selected
thresholds should be returned.}

\item{selContrast}{A numeric vector specifying for which contrast the output
should be retrieved. The contrast number corresponds to the position of the
column in the automatically generated or specified contrast matrix.}
}
\value{
A list with the filtering criteria applied when filtering the
anota2seqAnalyze output using the anota2seqSelSigGenes function. For details
on filtering criteria see anota2seqSelSigGenes function help.
}
\description{
Get the filtering criteria used for the anota2seqSelSigGenes function.
}
\examples{
data(anota2seq_data)
#Initialize Anota2seqDataSet
Anota2seqDataSet <- anota2seqDataSetFromMatrix(
    dataP = anota2seq_data_P[1:100,],
    dataT = anota2seq_data_T[1:100,],
    phenoVec = anota2seq_pheno_vec,
    dataType = "RNAseq",
    normalize = TRUE)
#Run analysis of differential translation
Anota2seqDataSet <- anota2seqAnalyze(Anota2seqDataSet, analysis = "translation")
#Run anota2seqSelSigGenes
Anota2seqDataSet <- anota2seqSelSigGenes(Anota2seqDataSet,
                                         analysis="translation",
                                         selContrast = 1,
                                         maxPAdj = .15)

# Get delta thresholds
thresholds <- anota2seqGetThresholds(Anota2seqDataSet,
                                       analysis = "translation",
                                       selContrast = 1)
}
\seealso{
\code{\link{anota2seqSelSigGenes}}
}
