% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anota2seqAllGenerics.R, R/anota2seqMethods.R
\docType{methods}
\name{anota2seqGetDeltaData}
\alias{anota2seqGetDeltaData}
\alias{anota2seqGetDeltaData,Anota2seqDataSet-method}
\title{Accessor for the fold changes and TE scores stored in the 'deltaData' 
slot of an Anota2seqDataSet object.}
\usage{
anota2seqGetDeltaData(object, output, analysis, selContrast)

\S4method{anota2seqGetDeltaData}{Anota2seqDataSet}(object, output, analysis, 
  selContrast)
}
\arguments{
\item{object}{An Anota2seqDataSet. Should contain the output of 
the anota2seqAnalyze function (and of anota2seqSelSigGenes if the output parameter
is set to "selected", see below).}

\item{output}{A character string specifying whether the deltaData output of the 
anota2seqAnalyze ("full", this will output deltaData for all genes) or of the 
anota2seqSelSigGenes ("selected", this will output deltaData for selected genes 
only) function should be returned.}

\item{analysis}{A character to specify for which analysis you want to 
retrieve the deltaData. Can be "translated mRNA", "total mRNA", "translation" or 
"buffering". Depending on the analysis parameter the 
returned deltaData will be influenced, i.e. when analysis is set to "total mRNA" 
a deltaT column will be returned, when analysis is set to "translated mRNA" 
a deltaP column will be returned; if analysis is set to "translation" a matrix 
with deltaP and deltaPT will be returned, if analysis is set to "buffering" a 
matrix with deltaT and deltaTP will be returned.}

\item{selContrast}{A numeric vector specifying for which contrast the output 
should be retrieved. The contrast number corresponds to the position of the
column in the automatically generated or specified contrast matrix.}
}
\value{
A matrix containing rows for all identifiers for 
  the specified analysis and contrast. The matrix contains the following 
  columns depending on analysis: \itemize{ \item deltaP: log2 fold change of
  translated mRNA across treatments (e.g. polysome-associated mRNA or RPF) 
  \item deltaT: log2 fold changes of total mRNA across treatments, \item
  deltaPT: mean log2(translated mRNA data / total mRNA data) between treatments 
  difference \item deltaTP: mean log2(total mRNA data / translated mRNA data) 
  between treatments difference } When analysis is "translated mRNA" the matrix 
  contains deltaP. When analysis is "total mRNA" the matrix contains deltaT.
  When analysis is "translation" the matrix contains deltaP and deltaPT. When 
  analysis is "buffering" the matrix contains deltaT and deltaTP.
}
\description{
anota2seqAnalyze, anota2seqSelSigGenes and anota2seqRun calculate the fold 
change values of translated mRNA (e.g. polysome-associated mRNA or RPFs) and 
total mRNA. They also provide deltaPT which is the mean log2(translated mRNA 
data / total mRNA data) between treatments difference (also referred to as 
translational efficiency (TE) scores) and similarly deltaTP log2(total mRNA 
data/translated mRNA data). anota2seqGetDeltaData allows access these delta 
data that can be useful for plotting or custom filtering.
}
\examples{

data(anota2seq_data)
# Initialize Anota2seqDataSet
Anota2seqDataSet <- anota2seqDataSetFromMatrix(
    dataP = anota2seq_data_P[1:100,],
    dataT = anota2seq_data_T[1:100,],
    phenoVec = anota2seq_pheno_vec,
    dataType = "RNAseq",
    normalize = TRUE)
# Run analysis of differential translation
Anota2seqDataSet <- anota2seqAnalyze(Anota2seqDataSet, 
                                     analysis = "translation")
# Run anota2seqSelSigGenes 
Anota2seqDataSet <- anota2seqSelSigGenes(Anota2seqDataSet, 
                                         analysis="translation", 
                                         selContrast = 1,
                                         maxPAdj = .15)

# Get delta data
delta_translation <- anota2seqGetDeltaData(Anota2seqDataSet,
                                             output = "selected",
                                             analysis = "translation",
                                             selContrast = 1)

}
\seealso{
\code{\link{anota2seqAnalyze}}, \code{\link{anota2seqSelSigGenes}}
}
