% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{summarize_annotations}
\alias{summarize_annotations}
\title{Summarize annotation counts}
\usage{
summarize_annotations(annotated_regions, annotated_random, quiet = FALSE)
}
\arguments{
\item{annotated_regions}{The \code{GRanges} result of \code{annotate_regions()}.}

\item{annotated_random}{The \code{GRanges} result of \code{annotate_regions()} on the randomized regions created from \code{randomize_regions()}.}

\item{quiet}{Print progress messages (FALSE) or not (TRUE).}
}
\value{
A \code{tbl_df} of the number of regions per annotation type.
}
\description{
Given a \code{GRanges} of annotated regions, count the number of regions in each annotation type. If \code{annotated_random} is not \code{NULL}, then the same is computed for the random regions.
}
\details{
If a region is annotated to multiple annotations of the same \code{annot.type}, the region will only be counted once. For example, if a region were annotated to multiple exons, it would only count once toward the exons, but if it were annotated to an exon and an intron, it would count towards both.
}
\examples{
   ### An example of ChIP-seq peaks with signalValue

   # Get premade CpG annotations
   data('annotations', package = 'annotatr')

   file = system.file('extdata', 'Gm12878_Stat3_chr2.bed.gz', package = 'annotatr')
   r = read_regions(con = file, genome = 'hg19')

   a = annotate_regions(
       regions = r,
       annotations = annotations,
       ignore.strand = TRUE,
       quiet = FALSE)

   rnd = randomize_regions(regions = r)

   rnd_annots = annotate_regions(
       regions = rnd,
       annotations = annotations,
       ignore.strand = TRUE,
       quiet = FALSE)

   # Summarize the annotated regions without randomized regions
   s = summarize_annotations(annotated_regions = a)

   # Summarize the annotated regions with randomized regions
   s_rnd = summarize_annotations(
       annotated_regions = a,
       annotated_random = rnd_annots)

}
