% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reticulate_helpers.R
\name{reticulate-helpers}
\alias{reticulate-helpers}
\alias{py_to_r.collections.abc.Mapping}
\alias{py_to_r.anndata._core.anndata.AnnData}
\alias{r_to_py.AbstractAnnData}
\title{Reticulate Helper Functions for AnnData Conversion}
\usage{
\method{py_to_r}{collections.abc.Mapping}(x)

\method{py_to_r}{anndata._core.anndata.AnnData}(x)

\method{r_to_py}{AbstractAnnData}(x, convert = TRUE)
}
\arguments{
\item{x}{An AbstractAnnData object (any anndataR implementation)}

\item{convert}{Whether to convert the result (passed to reticulate)}
}
\value{
A \code{\link{ReticulateAnnData}} object wrapping the Python object

A Python AnnData object
}
\description{
This file contains helper functions that enable seamless conversion between
R and Python AnnData objects using the reticulate package. These functions
provide automatic S3 method dispatch for converting AnnData objects across
the R-Python boundary.
}
\details{
The main conversion functions include:
\itemize{
\item \code{py_to_r.anndata._core.anndata.AnnData}: Converts Python AnnData
objects to R \link{ReticulateAnnData} objects
\item \code{r_to_py.AbstractAnnData}: Converts R \link{AbstractAnnData} objects
to Python AnnData objects
\item \code{py_to_r.collections.abc.Mapping}: Converts Python mapping
objects to R lists
}

These functions are automatically registered as S3 methods and are called
when using \code{reticulate::py_to_r()} and \code{reticulate::r_to_py()} on compatible
objects.
}
\examples{
\donttest{
# Requires Python anndata to be installed
if (requireNamespace("reticulate", quietly = TRUE) &&
      reticulate::py_module_available("anndata")) {

  library(reticulate)

  # Create Python AnnData object
  ad_py <- import("anndata", convert = FALSE)
  py_adata <- ad_py$AnnData(X = r_to_py(matrix(1:12, 3, 4)))

  # Automatic conversion to R (uses py_to_r.anndata._core.anndata.AnnData)
  r_adata <- py_to_r(py_adata)

  # Automatic conversion back to Python (uses r_to_py.AbstractAnnData)
  py_adata2 <- r_to_py(r_adata)
}
}
}
\seealso{
Other object converters: 
\code{\link{as_AnnData}()},
\code{\link{as_HDF5AnnData}()},
\code{\link{as_InMemoryAnnData}()},
\code{\link{as_ReticulateAnnData}()},
\code{\link{as_Seurat}()},
\code{\link{as_SingleCellExperiment}()}
}
\concept{object converters}
