% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_dataset.R, R/generator_types.R
\name{generate_dataset}
\alias{generate_dataset}
\alias{get_generator_types}
\title{Generate a mock dataset}
\usage{
generate_dataset(
  n_obs = 10L,
  n_vars = 20L,
  x_type = "numeric_matrix",
  layer_types = get_generator_types(slot = "layers"),
  obs_types = get_generator_types(slot = "obs"),
  var_types = get_generator_types(slot = "var"),
  obsm_types = get_generator_types(slot = "obsm"),
  varm_types = get_generator_types(slot = "varm"),
  obsp_types = get_generator_types(slot = "obsp"),
  varp_types = get_generator_types(slot = "varp"),
  uns_types = get_generator_types(slot = "uns"),
  example = FALSE,
  format = c("list", "AnnData", "SingleCellExperiment", "Seurat")
)

get_generator_types(example = FALSE, slot = NULL)
}
\arguments{
\item{n_obs}{Number of observations to generate}

\item{n_vars}{Number of variables to generate}

\item{x_type}{Type of matrix to generate for \code{X}}

\item{layer_types}{Types of matrices to generate for \code{layers}}

\item{obs_types}{Types of vectors to generate for \code{obs}}

\item{var_types}{Types of vectors to generate for \code{var}}

\item{obsm_types}{Types of matrices to generate for \code{obsm}}

\item{varm_types}{Types of matrices to generate for \code{varm}}

\item{obsp_types}{Types of matrices to generate for \code{obsp}}

\item{varp_types}{Types of matrices to generate for \code{varp}}

\item{uns_types}{Types of objects to generate for \code{uns}}

\item{example}{If \code{TRUE}, the types will be overridden with a small subset of
types. This is useful for documentation.}

\item{format}{Object type to output, one of "list", "AnnData",
"SingleCellExperiment", or "Seurat".}

\item{slot}{Which slot to return types for, if \code{NULL} a named list of all
slots is returned}
}
\value{
For \code{generate_dataset()}, an object as defined by \code{output} containing
the generated dataset

For \code{get_generator_types()}, a named list of character vectors or a
single character vector if \code{slot} is not \code{NULL}
}
\description{
Generate a mock synthetic dataset with different types of columns and layers.
This is primarily designed for use in tests, examples, vignettes and other
documentation but is also provided to users for creating reproducible
examples.

Use \code{get_generator_types()} to get the available types for each slot.
}
\details{
To generate no data for a given slot, set the matching type argument to
\code{NULL} or an empty vector, e.g. \code{obs_types = c()} will generate an empty
\code{obs} data frame.

When generating \code{SingleCellExperiment} or \code{Seurat} objects, only some of the
generated slots will be included in the output object. To generate a more
complete object, use \code{format = "AnnData"} followed by
\code{adata$as_SingleCellExperiment()} or \code{adata$as_Seurat()}.

Use \code{get_generator_types()} to get a list of the available types for each
slot, or for a specific slot by setting \code{slot}. If \code{example = TRUE}, only the
example types are returned.
}
\examples{
# Generate all types as a list
dummy <- generate_dataset()

# Generate the example types
dummy_example <- generate_dataset(example = TRUE)

# Generate an AnnData
dummy_anndata <- generate_dataset(format = "AnnData", example = TRUE)

# Generate a SingleCellExperiment
if (rlang::is_installed("SingleCellExperiment")) {
  dummy_sce <- generate_dataset(format = "SingleCellExperiment", example = TRUE)
}

# Generate a Seurat object
if (rlang::is_installed("SeuratObject")) {
  dummy_seurat <- generate_dataset(format = "Seurat", example = TRUE)
}

# Get all available generator types
get_generator_types()

# Get generator types for a specific slot
get_generator_types(slot = "obs")

# Get generator types used when example = TRUE
get_generator_types(example = TRUE)
}
