% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_SingleCellExperiment.R
\name{as_SingleCellExperiment}
\alias{as_SingleCellExperiment}
\title{Convert an \code{AnnData} to a \code{SingleCellExperiment}}
\usage{
as_SingleCellExperiment(
  adata,
  x_mapping = NULL,
  assays_mapping = TRUE,
  colData_mapping = TRUE,
  rowData_mapping = TRUE,
  reducedDims_mapping = TRUE,
  colPairs_mapping = TRUE,
  rowPairs_mapping = TRUE,
  metadata_mapping = TRUE
)
}
\arguments{
\item{adata}{The \code{AnnData} object to convert}

\item{x_mapping}{A string specifying the name of the assay in the resulting
\code{SingleCellExperiment} where the data in the \code{X} slot of \code{adata} will be
mapped to}

\item{assays_mapping}{A named vector where names are names of \code{assays} in the
resulting \code{SingleCellExperiment} object and values are keys of \code{layers} in
\code{adata}. See below for details.}

\item{colData_mapping}{A named vector where names are columns of \code{colData} in
the resulting \code{SingleCellExperiment} object and values are columns of \code{obs}
in \code{adata}. See below for details.}

\item{rowData_mapping}{A named vector where names are columns of \code{rowData} in
the resulting \code{SingleCellExperiment} object and values are columns of \code{var}
in \code{adata}. See below for details.}

\item{reducedDims_mapping}{A named vector where names are names of
\code{reducedDims} in the resulting \code{SingleCellExperiment} object and values are
keys of \code{obsm} in \code{adata}. Alternatively, a named list where names are
names of \code{reducedDims} in the resulting \code{SingleCellExperiment} object and
values are vectors with the items \code{"sampleFactors"} and \code{"featureLoadings"}
and/or \code{"metadata"}. See below for details.}

\item{colPairs_mapping}{A named vector where names are names of \code{colPairs} in
the resulting \code{SingleCellExperiment} object and values are keys of \code{obsp}
in \code{adata}. See below for details.}

\item{rowPairs_mapping}{A named vector where names are names of \code{rowPairs} in
the resulting \code{SingleCellExperiment} object and values are keys of \code{varp}
in \code{adata}. See below for details.}

\item{metadata_mapping}{A named vector where names are names of \code{metadata} in
the resulting \code{SingleCellExperiment} object and values are keys of \code{uns} in
\code{adata}. See below for details.}
}
\value{
A \code{SingleCellExperiment} object containing the requested data from
\code{adata}
}
\description{
Convert an \code{AnnData} object to a \code{SingleCellExperiment} object
}
\details{
\subsection{Mapping arguments}{

All mapping arguments expect a named character vector where names are the
names of the slot in the \code{SingleCellExperiment} object and values are the
keys of the corresponding slot of \code{adata}. If \code{TRUE}, the conversion function
will guess which items to copy as described in the conversion tables below.
In most cases, the default is to copy all items using the same names except
where the correspondence between objects is unclear. The
\code{reducedDims_mapping} argument can also accept a more complex list format,
see below for details. To avoid copying anything to a slot, set the mapping
argument to \code{FALSE}. Empty mapping arguments (\code{NULL}, \code{c()}, \code{list()}) will
be treated as \code{FALSE} with a warning. If an unnamed vector is provided, the
values will be used as names.
\subsection{Examples:}{
\itemize{
\item \code{TRUE} will guess which items to copy as described in the conversion
table
\item \code{c(sce_item = "adata_item")} will copy \code{adata_item} from the slot in
\code{adata} to \code{sce_item} in the corresponding slot of the new
\code{SingleCellExperiment} object
\item \code{FALSE} will avoid copying anything to the slot
\item \code{c("adata_item")} is equivalent to \code{c(adata_item = "adata_item")}
}
}

}

\subsection{Conversion table}{\tabular{llll}{
   \strong{From \code{AnnData}} \tab \strong{To \code{SingleCellExperiment}} \tab \strong{Example mapping argument} \tab \strong{Default} \cr
   \code{adata$X} \tab \code{assays(sce)} \tab \code{x_mapping = "counts"} \tab The data in \code{adata$X} is copied to the assay named \code{X} \cr
   \code{adata$layers} \tab \code{assays(sce)} \tab \code{assays_mapping = c(counts = "counts")} \tab All items are copied by name \cr
   \code{adata$obs} \tab \code{colData(sce)} \tab \code{colData_mapping = c(n_counts = "n_counts", cell_type = "CellType")} \tab All columns are copied by name \cr
   \code{adata$var} \tab \code{rowData(sce)} \tab \code{rowData_mapping = c(n_cells = "n_cells", pct_zero = "PctZero")} \tab All columns are copied by name \cr
   \code{adata$obsm} \tab \code{reducedDims(sce)} \tab \code{reducedDims_mapping = c(pca = "X_pca")} \strong{OR} \code{reducedDims_mapping = list(pca = c(sampleFactors = "X_pca", featureLoadings = "PCs", metadata = "pca_metadata"))} \tab All items are copied by name without loadings except for \code{"X_pca"} for which loadings are added from \code{"PCs"} \cr
   \code{adata$obsp} \tab \code{colPairs(sce)} \tab \code{colPairs_mapping = c(nn = "connectivities")} \tab All items are copied by name \cr
   \code{adata$varp} \tab \code{rowPairs(sce)} \tab \code{rowPairs_mapping = c(gene_overlaps = "similarities")} \tab All items are copied by name \cr
   \code{adata$uns} \tab \code{metadata(sce)} \tab \code{uns_mapping = c(project_metadata = "metadata")} \tab All items are copied by name \cr
}

}

\subsection{The \code{reducedDims_mapping} argument}{

For the simpler named vector format, the names should be the names of
\code{reducedDims} in the resulting \code{SingleCellExperiment} object, and the values
should be the keys of \code{obsm} in \code{adata}.

For more advanced mapping, use the list format where each item is a vector
with the following names used to create a
\code{\link[SingleCellExperiment:LinearEmbeddingMatrix]{SingleCellExperiment::LinearEmbeddingMatrix}} (if \code{featureLoadings} or
\code{metadata} is provided):
\itemize{
\item \code{sampleFactors}: a key of the \code{obsm} slot in \code{adata},
\code{adata$obsm[[sampleFactors]]} is passed to the \code{sampleFactors} argument
\item \code{featureLoadings}: a key of the \code{varm} slot in \code{adata} (optional),
\code{adata$varm[[featureLoadings]]} is passed to the \code{featureLoadings} argument
\item \code{metadata}: a key of the \code{uns} slot in \code{adata} (optional),
\code{adata$uns[[metadata]]} is passed to the \code{metadata} argument
}
}

\subsection{The \code{x_mapping} and \code{assays_mapping} arguments}{

In order to specify where the data in \code{adata$X} will be stored in the
\code{assays(sce)} slot of the resulting object, you can use either the
\code{x_mapping} argument or the \code{assays_mapping} argument.
If you use \code{x_mapping}, it should be a string specifying the name of the
layer in \code{assays(sce)} where the data in \code{adata$X} will be stored.
If you use \code{assays_mapping}, it should be a named vector where names are
names of \code{assays(sce)} and values are keys of \code{layers} in \code{adata}.
In order to indicate the \code{adata$X} slot, you use \code{NA} as the value in the
vector. The name you provide for \code{x_mapping} may not be a name in
\code{assays_mapping}.
}
}
\examples{
\dontshow{if (rlang::is_installed("SingleCellExperiment")) withAutoprint(\{ # examplesIf}
  ad <- AnnData(
    X = matrix(1:5, 3L, 5L),
    layers = list(A = matrix(5:1, 3L, 5L), B = matrix(letters[1:5], 3L, 5L)),
    obs = data.frame(row.names = LETTERS[1:3], cell = 1:3),
    var = data.frame(row.names = letters[1:5], gene = 1:5)
  )

  # Default usage
  sce <- ad$as_SingleCellExperiment(
    assays_mapping = TRUE,
    colData_mapping = TRUE,
    rowData_mapping = TRUE,
    reducedDims_mapping = TRUE,
    colPairs_mapping = TRUE,
    rowPairs_mapping = TRUE,
    metadata_mapping = TRUE
 )
\dontshow{\}) # examplesIf}
}
\seealso{
Other object converters: 
\code{\link{as_AnnData}()},
\code{\link{as_HDF5AnnData}()},
\code{\link{as_InMemoryAnnData}()},
\code{\link{as_ReticulateAnnData}()},
\code{\link{as_Seurat}()},
\code{\link{reticulate-helpers}}
}
\concept{object converters}
