% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimred_pcoa.R
\name{dimred_pcoa}
\alias{dimred_pcoa}
\title{Dimensionality reduction through PCoA}
\usage{
dimred_pcoa(
  MAE,
  tax_level,
  color,
  shape = NULL,
  axx = 1,
  axy = 2,
  axz = NULL,
  method = c("bray", "jaccard")
)
}
\arguments{
\item{MAE}{A multi-assay experiment object}

\item{tax_level}{The taxon level used for organisms}

\item{color}{A condition to color data points by e.g. "AGE"}

\item{shape}{A condition to shape data points by e.g. "SEX"}

\item{axx}{Principle coordinate on the x-axis e.g. 1}

\item{axy}{Principle coordinate on the y-axis e.g. 2}

\item{axz}{Principle coordinate on the z-axis e.g. 2}

\item{method}{Method to use e.g. c("bray", "jaccard")}
}
\value{
A list with a plotly object and summary table
}
\description{
Dimensionality reduction through PCoA
}
\examples{
data_dir <- system.file("extdata/MAE.rds", package = "animalcules")
toy_data <- readRDS(data_dir)
result <- dimred_pcoa(toy_data,
  tax_level = "genus",
  color = "AGE",
  shape = "DISEASE",
  axx = 1,
  axy = 2,
  method = "bray"
)
result$plot
result$table

}
