% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_abundance.R
\name{differential_abundance}
\alias{differential_abundance}
\title{Differential abundance analysis}
\usage{
differential_abundance(
  MAE,
  tax_level,
  input_da_condition = c(),
  input_da_condition_covariate = NULL,
  min_num_filter = 5,
  input_da_padj_cutoff = 0.05,
  method = "DESeq2"
)
}
\arguments{
\item{MAE}{A multi-assay experiment object}

\item{tax_level}{The taxon level used for organisms}

\item{input_da_condition}{Which condition is the target condition}

\item{input_da_condition_covariate}{Covariates added to linear function}

\item{min_num_filter}{Minimum number reads mapped to this microbe}

\item{input_da_padj_cutoff}{adjusted pValue cutoff}

\item{method}{choose between DESeq2 and limma}
}
\value{
A output dataframe
}
\description{
Differential abundance analysis
}
\examples{
data_dir <- system.file("extdata/MAE.rds", package = "animalcules")
toy_data <- readRDS(data_dir)
differential_abundance(toy_data,
  tax_level = "phylum",
  input_da_condition = c("DISEASE"),
  min_num_filter = 2,
  input_da_padj_cutoff = 0.5,
  method = "DESeq2"
)

}
