% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AlignmentsExperimentSet-class.R
\name{lookupAlignment}
\alias{lookupAlignment}
\title{Show alignment in human readable format.}
\usage{
lookupAlignment(x, ID, read_id = 1)
}
\arguments{
\item{x}{(AlignmentsExperimentSet)}

\item{ID}{(string) Experiment Identifier}

\item{read_id}{(numeric) Read Identifier. Reads are sorted by frequency.
Defaults to 1, most abundant read.}
}
\value{
(print to view)
}
\description{
Prints alignments in blast-like style for human examination.
}
\examples{
# load example object
file_path <- system.file("extdata", "results", "alignments",
                         "AlignmentsExperimentSet.rds", package = "amplican")
aln <- readRDS(file_path)
# look at most frequent reads aligned from experiment ID_1
lookupAlignment(aln, "ID_1")

}
\keyword{internal}
