% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_alignment.R
\name{locate_pr_start}
\alias{locate_pr_start}
\title{Find full or partial primer start positions with mismatches.}
\usage{
locate_pr_start(reads, primer, m = 3, min_overlap = ceiling(nchar(primer)/2))
}
\arguments{
\item{reads}{A character vector of DNA sequences.}

\item{primer}{A single character string for the primer sequence.}

\item{m}{The maximum number of allowed mismatches.}

\item{min_overlap}{The minimum number of base pairs the primer must overlap
with the read. A good value is often around half the primer length.}
}
\value{
A numeric vector of the EARLIEST start position for a valid match,
  with NA for no match.
}
\description{
This function finds a primer that can be partially truncated at the 5' end.
It handles both full matches inside the read and partial matches at the
beginning of the read.
}
