% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_alignment.R
\name{comb_along}
\alias{comb_along}
\title{Generate all combinations along string exchanging m characters at a time with
dictionary letters.}
\usage{
comb_along(seq, m = 2, letters = c("A", "C", "T", "G"))
}
\arguments{
\item{seq}{(character) input character to permutate}

\item{m}{(integer) number of elements to permutate at each step}

\item{letters}{(character vector) dictionary source for combinations of
elements}
}
\value{
(character vector) all unique combinations of permutated string
}
\description{
Generate all combinations along string \code{seq} swapping \code{m}
characters at a time with letters defined in dictionary \code{letters}.
Allows, for instance, to create a list of possible primers with two
mismatches.
}
\examples{
comb_along("AC")
comb_along("AAA", 1)
comb_along("AAA")
comb_along("AAA", 3)
comb_along("AAAAAAAAAA")

}
