% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readAlevinFryQC.R
\name{readAlevinFryQC}
\alias{readAlevinFryQC}
\title{Read alevin-fry data required to generate summary report}
\usage{
readAlevinFryQC(mapDir, permitDir, quantDir)
}
\arguments{
\item{mapDir}{Path to the output directory from the \code{salmon alevin}
run (should be the directory containing the \code{alevin} folder).}

\item{permitDir}{Path to the output directory from the
\code{generate-permit-list} and \code{collate} runs.}

\item{quantDir}{Path to the output directory from the
\code{alevin-fry quant} run (should be the directory containing the
\code{alevin} folder).}
}
\value{
A list collecting all necessary information for generating the
    summary report/shiny app.
}
\description{
Read all alevin-fry output files required to generate the
summary report or shiny app.
}
\examples{
alevinfry <- readAlevinFryQC(
    mapDir = system.file("extdata/alevinfry_example_v0.5.0/map",
                         package = "alevinQC"),
    permitDir = system.file("extdata/alevinfry_example_v0.5.0/permit",
                            package = "alevinQC"),
    quantDir = system.file("extdata/alevinfry_example_v0.5.0/quant",
                           package = "alevinQC"))

}
\author{
Charlotte Soneson
}
