% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAlevinHistogram.R
\name{plotAlevinHistogram}
\alias{plotAlevinHistogram}
\title{Histogram of selected summary statistic}
\usage{
plotAlevinHistogram(
  cbTable,
  plotVar = "dedupRate",
  axisLabel = plotVar,
  colName = "inFinalWhiteList",
  cbName = "final whitelist",
  firstSelColName = "inFirstWhiteList"
)
}
\arguments{
\item{cbTable}{\code{data.frame} (such as the \code{cbTable} returned by
\code{readAlevinQC} or \code{readAlevinFryQC}) containing the desired
summary statistic in a column.}

\item{plotVar}{Character scalar giving the name of a numeric column of
\code{cbTable} to plot.}

\item{axisLabel}{Character scalar giving the label of the selected
statistic (will be displayed as the axis label in the plot).}

\item{colName}{Character scalar giving the name of a logical column of
\code{cbTable} to use for filling the bars in the histogram.}

\item{cbName}{Character scalar giving the name of the set of barcodes
defined by \code{colName}, used for labelling the plot legend.}

\item{firstSelColName}{Character scalar indicating the name of the logical
column in \code{cbTable} that corresponds to the original selection of
barcodes for quantification.}
}
\value{
A ggplot object
}
\description{
Histogram of selected summary statistic
}
\examples{
alevin <- readAlevinQC(system.file("extdata/alevin_example_v0.14",
                                   package = "alevinQC"))
plotAlevinHistogram(alevin$cbTable, plotVar = "dedupRate",
                    axisLabel = "Deduplication rate",
                    colName = "inFinalWhiteList",
                    cbName = "final whitelist")

}
\author{
Charlotte Soneson
}
