% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FastqFileReference.R
\docType{class}
\name{FastqFileReference}
\alias{FastqFileReference}
\alias{FastqFileReference-class}
\alias{saveObject,FastqFileReference-method}
\alias{readFastqFileReference}
\alias{FastqWrapper}
\alias{FastqWrapper-class}
\alias{stageObject,FastqWrapper-method}
\alias{show,FastqWrapper-method}
\alias{loadFastqWrapper}
\title{Reference to a FASTQ file}
\usage{
FastqFileReference(
  path,
  seqtype = "DNA",
  qualtype = "phred",
  qualoffset = 33,
  faindex = NULL,
  gzindex = NULL
)
}
\arguments{
\item{path}{String containing the path to a Gzip- or BGZF-compressed FASTQ file.}

\item{seqtype}{String specifying the sequence type.
This should be one of \code{"DNA"}, \code{"RNA"}, \code{"AA"} or \code{"custom"}.}

\item{qualtype}{String specifying the type of the quality strings.
This should be one of \code{"phred"} or \code{"solexa"}.}

\item{qualoffset}{Integer specifying the encoding offset for the quality strings.
This is only used when \code{qualtype="phred"}, in which case it should either be 33 or 64.}

\item{faindex}{String specifying the path to an FASTA index file, or \code{NULL} if no index is available.
If an index is supplied, the file at \code{path} should be BGZF-compressed, and \code{gzindex} should also be supplied.}

\item{gzindex}{String specifying the path to a BGZF index file, or \code{NULL} if no index is available.
If an index is supplied, the file at \code{path} should be BGZF-compressed, and \code{faindex} should also be supplied.}
}
\value{
A FastqFileReference instance that can be used in \code{\link{saveObject}}.
}
\description{
Reference to a FASTQ file, for saving and loading in the \pkg{alabaster} framework.
}
\examples{
# Mocking up a FASTQ file.
tmp <- tempfile(fileext=".fq.gz")
write("@FOOBAR\nacgtacgt\n+134987382", gzfile(tmp))

# Creating a FastqFileReference.
wrapped <- FastqFileReference(tmp)
wrapped

# Staging the FastqFileReference.
dir <- tempfile()
saveObject(wrapped, dir)
list.files(dir, recursive=TRUE)

# Loading it back again:
readObject(dir)

}
\author{
Aaron Lun
}
