% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readMetadata.R
\name{readMetadata}
\alias{readMetadata}
\alias{restoreMetadata}
\alias{.restoreMetadata}
\title{Read R-level metadata}
\usage{
readMetadata(x, metadata.path, mcols.path, ...)
}
\arguments{
\item{x}{An \link[S4Vectors]{Vector} or \link[S4Vectors]{Annotated} object.}

\item{metadata.path}{String containing a path to a directory, itself containing an on-disk representation of a base R list to be used as the \code{\link[S4Vectors]{metadata}}.
Alternatively \code{NULL} to skip loading.}

\item{mcols.path}{String containing a path to a directory, itself containing an on-disk representation of a \link[S4Vectors]{DataFrame} to be used as the \code{\link[S4Vectors]{mcols}}.
Alternatively \code{NULL} to skip loading.}

\item{...}{Further arguments to be passed to \code{\link{altReadObject}}.}
}
\value{
\code{x} is returned, possibly with \code{mcols} and \code{metadata} added to it.
}
\description{
Read \code{\link[S4Vectors]{metadata}} and \code{\link[S4Vectors]{mcols}} for a \link[S4Vectors]{Annotated} or \link[S4Vectors]{Vector} object, respectively.
This is typically used inside loading functions for concrete subclasses.
}
\seealso{
\code{\link{saveMetadata}}, which does the staging.
}
\author{
Aaron Lun
}
