% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloneFile.R
\name{cloneFile}
\alias{cloneFile}
\title{Clone an existing file}
\usage{
cloneFile(src, dest, action = c("link", "copy", "symlink", "relsymlink"))
}
\arguments{
\item{src}{String containing the path to the source file.}

\item{dest}{String containing the destination file path, typically within the \code{path} supplied to \code{\link{saveObject}}.}

\item{action}{String specifying the action to use when cloning \code{src} to \code{dest}.
\itemize{
\item \code{"copy"}: copy \code{src} to \code{dest}.
\item \code{"link"}: create a hard link from \code{src} to \code{dest}.
If this fails, we silently fall back to a copy.
\item \code{"symlink"}: create a symbolic link from \code{src} to \code{dest}.
The symbolic link contains the absolute path to \code{src}, which is useful when \code{dest} might be moved but \code{src} will not.
\item \code{"relsymlink"}: create a symbolic link from \code{src} to \code{dest}.
Each symbolic link contains the minimal relative path to \code{src},
which is useful when both \code{src} and \code{dest} are moved together, e.g., as they are part of the same parent object like a SummarizedExperiment.
}}
}
\value{
A new file/link is created at \code{dest}.
\code{NULL} is invisibly returned.
}
\description{
Clone an existing file to a new location.
This is typically performed inside \code{\link{saveObject}} methods for objects that contain a reference to a file.
}
\examples{
tmp <- tempfile()
write(file=tmp, LETTERS)

dest <- tempfile()
cloneFile(tmp, dest)
readLines(dest)

}
\seealso{
\code{\link{cloneDirectory}}, to clone entire directories.
}
\author{
Aaron Lun
}
