% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterAdductTable.R
\name{filterAdductTable}
\alias{filterAdductTable}
\title{filter samples with low QC and features with large missing values
Removes adducts that have not been integrated with many missing values
and provides QC on samples}
\usage{
filterAdductTable(adductTable = NULL, percMissing = 51, HKPmass = 
"575.3", quantPeptideMass = "811.7", remHKPzero = FALSE, remQuantPepzero 
=FALSE, remHKPlow = FALSE, outputDir = NULL)
}
\arguments{
\item{adductTable}{character a full path to the peaktable with number of 
rows equal to the number of adducts from outputPeakTable()
which starts with adductQuantif_peakList_}

\item{percMissing}{numeric percentage threshold to remove adducts with 
missing values. Default
is 51. It is recommended to use just over the number of samples in the 
smallest
group of your study. 51 is used as default for a 50:50 case control study}

\item{HKPmass}{numeric mass for the housekeeping peptide. Must be the same
asthat in the adduct table. max 2 decimal places.
default= 575.3 for the LVNEVTEFAK peptide}

\item{quantPeptideMass}{numeric mass for the peptide for which adducts are 
being quantified, 
Default is
811.7 for the ALVLIAFAQYLQQCPFEDHVK peptide}

\item{remHKPzero}{logical if TRUE removes all samples where the 
housekeeping peptide is 0. default= FALSE}

\item{remQuantPepzero}{logical if TRUE removes all samples where the 
peptide under quantification is 0. default= FALSE}

\item{remHKPlow}{logical if TRUE removes all samples where the 
housekeeping peptide has an area less than 100000. 
default= TRUE.This is recommended because this peak should be large. 
If the HKP
has been mis-identified quantification of all adducts will be affected.}

\item{outputDir}{character path to results directory
output is a csv file with only adducts and samples that passed filter. 
Remaining adducts can be quantified manually 
however it is recommended to rescale the quantification results and include
the quantification method as a covariate in downstream analysis.}
}
\value{
csv file
}
\description{
filter samples with low QC and features with large missing values
Removes adducts that have not been integrated with many missing values
and provides QC on samples
}
\examples{
filterAdductTable(adductTable=paste0(system.file("extdata",
package="adductomicsR"),'/example_adductQuantif_peakList.csv'), percMissing
=51,HKPmass = "575.3", quantPeptideMass = "811.7",
remHKPzero=FALSE,remQuantPepzero = FALSE, remHKPlow = FALSE, outputDir =
NULL)
}
